/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.user.client.ui.TextBox;

public abstract class AbstractRestrictedEntryTextBox
extends TextBox {
    protected final boolean allowEmptyValue;

    public AbstractRestrictedEntryTextBox() {
        this(false);
    }

    public AbstractRestrictedEntryTextBox(boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
        this.setup();
    }

    protected void setup() {
        final AbstractRestrictedEntryTextBox me = this;
        this.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                int keyCode = event.getNativeEvent().getKeyCode();
                if (event.isControlKeyDown() || keyCode == 8 || keyCode == 46 || keyCode == 37 || keyCode == 39 || keyCode == 9) {
                    return;
                }
                char charCode = event.getCharCode();
                String oldValue = me.getValue();
                String newValue = oldValue.substring(0, me.getCursorPos());
                newValue = newValue + (char)charCode;
                if (!AbstractRestrictedEntryTextBox.this.isValidValue(newValue = newValue + oldValue.substring(me.getCursorPos() + me.getSelectionLength()), false)) {
                    event.preventDefault();
                }
            }
        });
        this.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                String value = me.getText();
                if (!AbstractRestrictedEntryTextBox.this.isValidValue(value, true)) {
                    String validValue = AbstractRestrictedEntryTextBox.this.makeValidValue(value);
                    me.setText(validValue);
                    ValueChangeEvent.fire((HasValueChangeHandlers)AbstractRestrictedEntryTextBox.this, (Object)validValue);
                }
            }
        });
    }

    public abstract boolean isValidValue(String var1, boolean var2);

    protected String makeValidValue(String value) {
        return "";
    }
}

