/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotatingLogFile
implements Comparable<RotatingLogFile> {
    private static Logger log = LoggerFactory.getLogger(RotatingLogFile.class);
    private static final String LOG_EXTENSION = "log";
    private final File directory;
    private final String basename;
    private final File file;
    private int version;

    private RotatingLogFile(File directory, String basename, File file) throws IllegalArgumentException {
        this.directory = directory;
        this.basename = basename;
        this.file = file;
        this.parseName();
    }

    private void parseName() throws IllegalArgumentException {
        String name = this.file.getName();
        int sep1 = name.indexOf(46);
        if (sep1 == -1) {
            throw new IllegalArgumentException("no dot in filename.");
        }
        if (!this.basename.equals(name.substring(0, sep1))) {
            throw new IllegalArgumentException("name does not start with " + this.basename + ".");
        }
        int sep2 = name.indexOf(46, sep1 + 1);
        if (sep2 == -1) {
            sep2 = name.length();
        }
        if (!LOG_EXTENSION.equals(name.substring(sep1 + 1, sep2))) {
            throw new IllegalArgumentException("name does not contain log.");
        }
        if (sep2 < name.length()) {
            String versionS = name.substring(sep2 + 1);
            try {
                this.version = Integer.parseInt(versionS);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("extension is not a number: " + versionS);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void rotate() {
        String newName = this.basename + "." + LOG_EXTENSION + "." + String.valueOf(this.version + 1);
        this.file.renameTo(new File(this.directory, newName));
    }

    @Override
    public int compareTo(RotatingLogFile o) {
        return this.version - o.version;
    }

    public static RotatingLogFile[] listFiles(File directory, final String basename) {
        File[] files = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(basename + ".");
            }
        });
        ArrayList<RotatingLogFile> l = new ArrayList<RotatingLogFile>();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                l.add(new RotatingLogFile(directory, basename, file));
                continue;
            }
            catch (IllegalArgumentException e) {
                log.warn("Bogusly named journal file, skipped: " + files[i] + ", reason: " + e.getMessage());
            }
        }
        RotatingLogFile[] logFiles = new RotatingLogFile[l.size()];
        l.toArray(logFiles);
        Arrays.sort(logFiles, new Comparator<RotatingLogFile>(){

            @Override
            public int compare(RotatingLogFile o1, RotatingLogFile o2) {
                return o2.compareTo(o1);
            }
        });
        return logFiles;
    }
}

