/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.migrater.util;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.Module;
import org.drools.repository.AssetItem;
import org.kie.commons.java.nio.file.Path;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.FileSystem;
import org.uberfire.backend.vfs.PathFactory;

@ApplicationScoped
public class MigrationPathManager {
    @Inject
    private Paths paths;
    @Inject
    @Named(value="migrationFS")
    private org.kie.commons.java.nio.file.FileSystem fs;
    private Map<String, org.uberfire.backend.vfs.Path> uuidToPathMap = new HashMap<String, org.uberfire.backend.vfs.Path>();
    private Map<org.uberfire.backend.vfs.Path, String> pathToUuidMap = new HashMap<org.uberfire.backend.vfs.Path, String>();

    public org.uberfire.backend.vfs.Path generateRootPath() {
        Path _path = this.fs.getPath("/", new String[0]);
        return this.paths.convert(_path, false);
    }

    public org.uberfire.backend.vfs.Path generatePathForModule(Module jcrModule) {
        Path modulePath = this.fs.getPath("/" + this.escapePathEntry(jcrModule.getName()), new String[0]);
        org.uberfire.backend.vfs.Path path = PathFactory.newPath((FileSystem)this.paths.convert(modulePath.getFileSystem()), (String)modulePath.getFileName().toString(), (String)modulePath.toUri().toString());
        this.register(jcrModule.getUuid(), path);
        return path;
    }

    public org.uberfire.backend.vfs.Path generatePathForAsset(Module jcrModule, Asset jcrAsset, boolean hasDSL) {
        Path modulePath = this.fs.getPath("/" + this.escapePathEntry(jcrModule.getName()), new String[0]);
        Path assetPath = null;
        assetPath = "brl".equals(jcrAsset.getFormat()) && !hasDSL ? modulePath.resolve("src/main/resources/" + jcrAsset.getName() + ".rdrl") : ("brl".equals(jcrAsset.getFormat()) && hasDSL ? modulePath.resolve("src/main/resources/" + jcrAsset.getName() + ".rdslr") : modulePath.resolve("src/main/resources/" + jcrAsset.getName() + "." + jcrAsset.getFormat()));
        org.uberfire.backend.vfs.Path path = PathFactory.newPath((FileSystem)this.paths.convert(assetPath.getFileSystem()), (String)assetPath.getFileName().toString(), (String)assetPath.toUri().toString());
        this.register(jcrAsset.getUuid(), path);
        return path;
    }

    public org.uberfire.backend.vfs.Path generatePathForAsset(Module jcrModule, Asset jcrAsset) {
        return this.generatePathForAsset(jcrModule, jcrAsset, false);
    }

    public org.uberfire.backend.vfs.Path generatePathForAsset(Module jcrModule, AssetItem jcrAssetItem, boolean hasDSL) {
        Path modulePath = this.fs.getPath("/" + this.escapePathEntry(jcrModule.getName()), new String[0]);
        Path assetPath = null;
        assetPath = "brl".equals(jcrAssetItem.getFormat()) && !hasDSL ? modulePath.resolve("src/main/resources/" + jcrAssetItem.getName() + ".rdrl") : ("brl".equals(jcrAssetItem.getFormat()) && hasDSL ? modulePath.resolve("src/main/resources/" + jcrAssetItem.getName() + ".rdslr") : ("scenario".equals(jcrAssetItem.getFormat()) ? modulePath.resolve("src/test/resources/" + jcrAssetItem.getName() + "." + jcrAssetItem.getFormat()) : modulePath.resolve("src/main/resources/" + jcrAssetItem.getName() + "." + jcrAssetItem.getFormat())));
        org.uberfire.backend.vfs.Path path = PathFactory.newPath((FileSystem)this.paths.convert(assetPath.getFileSystem()), (String)assetPath.getFileName().toString(), (String)assetPath.toUri().toString());
        this.register(jcrAssetItem.getUUID(), path);
        return path;
    }

    public org.uberfire.backend.vfs.Path generatePathForAsset(Module jcrModule, AssetItem jcrAssetItem) {
        return this.generatePathForAsset(jcrModule, jcrAssetItem, false);
    }

    private Path getPomDirectoryPath(org.uberfire.backend.vfs.Path pathToPomXML) {
        return this.paths.convert(pathToPomXML).getParent();
    }

    public String escapePathEntry(String pathEntry) {
        pathEntry = pathEntry.replaceAll("/", " slash ");
        return pathEntry;
    }

    protected void register(String uuid, org.uberfire.backend.vfs.Path path) {
        if (this.uuidToPathMap.containsKey(uuid)) {
            return;
        }
        if (this.pathToUuidMap.containsKey(path)) {
            return;
        }
        this.uuidToPathMap.put(uuid, path);
        this.pathToUuidMap.put(path, uuid);
    }

    public org.uberfire.backend.vfs.Path getPath(String uuid) {
        return this.uuidToPathMap.get(uuid);
    }

    public String getUuid(org.uberfire.backend.vfs.Path path) {
        return this.pathToUuidMap.get(path);
    }
}

