/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.migrater.asset;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactModels;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FieldMetaModel;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.repository.AssetItem;
import org.drools.workbench.jcr2vfsmigration.migrater.PackageImportHelper;
import org.drools.workbench.jcr2vfsmigration.migrater.util.MigrationPathManager;
import org.drools.workbench.screens.factmodel.service.FactModelService;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.commons.io.IOService;
import org.kie.workbench.common.screens.datamodeller.model.AnnotationDefinitionTO;
import org.kie.workbench.common.screens.datamodeller.model.DataModelTO;
import org.kie.workbench.common.screens.datamodeller.model.DataObjectTO;
import org.kie.workbench.common.screens.datamodeller.model.ObjectPropertyTO;
import org.kie.workbench.common.screens.datamodeller.model.PropertyTypeTO;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class FactModelsMigrater {
    protected static final Logger logger = LoggerFactory.getLogger(FactModelsMigrater.class);
    @Inject
    protected RepositoryAssetService jcrRepositoryAssetService;
    @Inject
    protected FactModelService vfsFactModelService;
    @Inject
    protected MigrationPathManager migrationPathManager;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private Paths paths;
    @Inject
    PackageImportHelper packageImportHelper;
    @Inject
    private ProjectService projectService;
    @Inject
    private DataModelerService modelerService;
    private Map<String, String> orderedBaseTypes = new TreeMap<String, String>();
    private Map<String, AnnotationDefinitionTO> annotationDefinitions;

    public void migrate(Module jcrModule, AssetItem jcrAssetItem) {
        if (!"model.drl".equals(jcrAssetItem.getFormat())) {
            throw new IllegalArgumentException("The jcrAsset (" + jcrAssetItem.getName() + ") has the wrong format (" + jcrAssetItem.getFormat() + ").");
        }
        Path path = this.migrationPathManager.generatePathForAsset(jcrModule, jcrAssetItem);
        Project project = this.projectService.resolveProject(path);
        this.initBasePropertyTypes();
        this.initAnnotationDefinitions();
        if (project == null) {
            Path projectRootPath = this.migrationPathManager.generatePathForModule(jcrModule);
            project = new Project(projectRootPath, projectRootPath, projectRootPath, projectRootPath, "");
        }
        try {
            Asset jcrAsset = this.jcrRepositoryAssetService.loadRuleAsset(jcrAssetItem.getUUID());
            FactModels factModels = (FactModels)jcrAsset.getContent();
            DataModelTO dataModelTO = new DataModelTO();
            String packageName = this.getPackageName(jcrModule);
            for (FactMetaModel factMetaModel : factModels.models) {
                DataObjectTO dataObjectTO = this.createDataObject(packageName, factMetaModel.getName(), factMetaModel.getSuperType());
                List annotationMetaModel = factMetaModel.getAnnotations();
                this.addAnnotations(dataObjectTO, annotationMetaModel);
                List fields = factMetaModel.getFields();
                for (FieldMetaModel fieldMetaModel : fields) {
                    String filedName = fieldMetaModel.name;
                    String fildType = fieldMetaModel.type;
                    boolean isMultiple = false;
                    boolean isBaseType = this.isBaseType(fildType);
                    ObjectPropertyTO property = new ObjectPropertyTO(filedName, fildType, isMultiple, isBaseType);
                    dataObjectTO.getProperties().add(property);
                }
                dataModelTO.getDataObjects().add(dataObjectTO);
            }
            this.modelerService.saveModel(dataModelTO, project);
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
    }

    private String getPackageName(Module jcrModule) {
        String packageName = jcrModule.getName();
        int dotIndex = packageName.indexOf(".");
        packageName = dotIndex == -1 ? "" : packageName.substring(dotIndex + 1);
        return packageName;
    }

    private void initBasePropertyTypes() {
        List baseTypes = this.modelerService.getBasePropertyTypes();
        if (baseTypes != null) {
            for (PropertyTypeTO type : baseTypes) {
                this.orderedBaseTypes.put(type.getName(), type.getClassName());
            }
        }
    }

    public Boolean isBaseType(String type) {
        return this.orderedBaseTypes.containsValue(type);
    }

    private void initAnnotationDefinitions() {
        this.annotationDefinitions = this.modelerService.getAnnotationDefinitions();
    }

    private DataObjectTO createDataObject(String packageName, String name, String superClass) {
        DataObjectTO dataObject = new DataObjectTO(name, packageName, superClass);
        return dataObject;
    }

    private void addAnnotations(DataObjectTO dataObject, List<AnnotationMetaModel> annotationMetaModelList) {
        for (AnnotationMetaModel annotationMetaModel : annotationMetaModelList) {
            String name = annotationMetaModel.name;
            Map values = annotationMetaModel.values;
            String key = "value";
            String value = "";
            if (values.size() > 0) {
                key = (String)values.keySet().iterator().next();
                value = (String)values.values().iterator().next();
            }
            if ("Role".equals(name)) {
                dataObject.addAnnotation(this.annotationDefinitions.get("org.kie.api.definition.type.Role"), key, (Object)value);
                continue;
            }
            if ("Position".equals(name)) {
                dataObject.addAnnotation(this.annotationDefinitions.get("org.kie.api.definition.type.Position"), key, (Object)value);
                continue;
            }
            if (!"Equals".equals(name)) continue;
            dataObject.addAnnotation(this.annotationDefinitions.get("org.kie.api.definition.type.Key"), key, (Object)value);
        }
    }
}

