/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.config;

import java.io.File;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class MigrationConfig {
    protected static final Logger logger = LoggerFactory.getLogger(MigrationConfig.class);
    public static String formatstr = "runMigration  [options...]";
    private File inputJcrRepository;
    private File outputVfsRepository;
    private boolean forceOverwriteOutputVfsRepository;

    public File getInputJcrRepository() {
        return this.inputJcrRepository;
    }

    public File getOutputVfsRepository() {
        return this.outputVfsRepository;
    }

    public boolean parseArgs(String[] args) {
        CommandLine commandLine;
        Options options = new Options();
        options.addOption("h", "help", false, "help for the command.");
        options.addOption("i", "inputJcrRepository", true, "The Guvnor 5 JCR repository");
        options.addOption("o", "outputVfsRepository", true, "The Guvnor 6 VFS repository");
        options.addOption("f", "forceOverwriteOutputVfsRepository", false, "Force overwriting the Guvnor 6 VFS repository");
        HelpFormatter formatter = new HelpFormatter();
        try {
            commandLine = new BasicParser().parse(options, args);
        }
        catch (ParseException e) {
            formatter.printHelp(formatstr, options);
            return false;
        }
        if (commandLine.hasOption("h")) {
            formatter.printHelp(formatstr, options);
            return false;
        }
        return this.parseArgInputJcrRepository(commandLine, formatter, options) && this.parseArgOutputVfsRepository(commandLine, formatter, options);
    }

    private boolean parseArgInputJcrRepository(CommandLine commandLine, HelpFormatter formatter, Options options) {
        this.inputJcrRepository = new File(commandLine.getOptionValue("i", "inputJcr"));
        if (!this.inputJcrRepository.exists()) {
            System.out.println("The inputJcrRepository (" + this.inputJcrRepository.getAbsolutePath() + ") does not exist. Please make sure your inputJcrRepository exists, or use -i to specify alternative location.");
            return false;
        }
        try {
            this.inputJcrRepository = this.inputJcrRepository.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The inputJcrRepository (" + this.inputJcrRepository + ") has issues.", e);
        }
        return true;
    }

    private boolean parseArgOutputVfsRepository(CommandLine commandLine, HelpFormatter formatter, Options options) {
        this.outputVfsRepository = new File(commandLine.getOptionValue("o", "outputVfs"));
        this.forceOverwriteOutputVfsRepository = commandLine.hasOption("f");
        if (this.outputVfsRepository.exists()) {
            if (this.forceOverwriteOutputVfsRepository) {
                try {
                    FileUtils.deleteDirectory((File)this.outputVfsRepository);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Force deleting outputVfsRepository (" + this.outputVfsRepository.getAbsolutePath() + ") failed.", e);
                }
            } else {
                System.out.println("The outputVfsRepository (" + this.outputVfsRepository.getAbsolutePath() + ") already exists.");
                return false;
            }
        }
        try {
            this.outputVfsRepository = this.outputVfsRepository.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The outputVfsRepository (" + this.outputVfsRepository + ") has issues.", e);
        }
        this.outputVfsRepository.mkdirs();
        return true;
    }
}

