/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.util.Date;
import org.apache.helix.alerts.AlertValueAndStatus;
import org.apache.helix.monitoring.mbeans.ClusterAlertItemMBean;

public class ClusterAlertItem
implements ClusterAlertItemMBean {
    String _alertItemName;
    double _alertValue;
    int _alertFired;
    String _additionalInfo = "";
    AlertValueAndStatus _valueAndStatus;
    long _lastUpdateTime = 0L;

    public ClusterAlertItem(String name, AlertValueAndStatus valueAndStatus) {
        this._valueAndStatus = valueAndStatus;
        this._alertItemName = name;
        this.refreshValues();
    }

    @Override
    public String getSensorName() {
        return this._alertItemName;
    }

    @Override
    public double getAlertValue() {
        return this._alertValue;
    }

    public void setValueMap(AlertValueAndStatus valueAndStatus) {
        this._valueAndStatus = valueAndStatus;
        this.refreshValues();
    }

    void refreshValues() {
        this._lastUpdateTime = new Date().getTime();
        this._alertValue = this._valueAndStatus.getValue().getElements().size() > 0 ? Double.parseDouble(this._valueAndStatus.getValue().getElements().get(0)) : 0.0;
        this._alertFired = this._valueAndStatus.isFired() ? 1 : 0;
    }

    @Override
    public int getAlertFired() {
        return this._alertFired;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this._additionalInfo = additionalInfo;
    }

    @Override
    public String getAdditionalInfo() {
        return this._additionalInfo;
    }

    public void reset() {
        this._alertFired = 0;
        this._additionalInfo = "";
        this._alertValue = 0.0;
    }

    public long getLastUpdateTime() {
        return this._lastUpdateTime;
    }
}

