/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.apache.log4j.Logger;

public class IdealState
extends HelixProperty {
    public static final String QUERY_LIST = "PREFERENCE_LIST_QUERYS";
    private static final Logger logger = Logger.getLogger((String)IdealState.class.getName());

    public IdealState(String resourceName) {
        super(resourceName);
    }

    public IdealState(ZNRecord record) {
        super(record);
    }

    public String getResourceName() {
        return this._record.getId();
    }

    public void setIdealStateMode(String mode) {
        this._record.setSimpleField(IdealStateProperty.IDEAL_STATE_MODE.toString(), mode);
    }

    public int getMaxPartitionsPerInstance() {
        try {
            String strVal = this._record.getSimpleField(IdealStateProperty.MAX_PARTITONS_PER_INSTANCE.toString());
            if (strVal != null) {
                return Integer.parseInt(strVal);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Integer.MAX_VALUE;
    }

    public void setRebalancerClassName(String rebalancerClassName) {
        this._record.setSimpleField(IdealStateProperty.REBALANCER_CLASS_NAME.toString(), rebalancerClassName);
    }

    public String getRebalancerClassName() {
        return this._record.getSimpleField(IdealStateProperty.REBALANCER_CLASS_NAME.toString());
    }

    public void setMaxPartitionsPerInstance(int max) {
        this._record.setSimpleField(IdealStateProperty.MAX_PARTITONS_PER_INSTANCE.toString(), Integer.toString(max));
    }

    public IdealStateModeProperty getIdealStateMode() {
        String mode = this._record.getSimpleField(IdealStateProperty.IDEAL_STATE_MODE.toString());
        try {
            return IdealStateModeProperty.valueOf(mode);
        }
        catch (Exception e) {
            return IdealStateModeProperty.AUTO;
        }
    }

    public void setPartitionState(String partitionName, String instanceName, String state) {
        Map<String, String> mapField = this._record.getMapField(partitionName);
        if (mapField == null) {
            this._record.setMapField(partitionName, new TreeMap<String, String>());
        }
        this._record.getMapField(partitionName).put(instanceName, state);
    }

    public Set<String> getPartitionSet() {
        if (this.getIdealStateMode() == IdealStateModeProperty.AUTO || this.getIdealStateMode() == IdealStateModeProperty.AUTO_REBALANCE) {
            return this._record.getListFields().keySet();
        }
        if (this.getIdealStateMode() == IdealStateModeProperty.CUSTOMIZED) {
            return this._record.getMapFields().keySet();
        }
        logger.error((Object)("Invalid ideal state mode:" + this.getResourceName()));
        return Collections.emptySet();
    }

    public Map<String, String> getInstanceStateMap(String partitionName) {
        return this._record.getMapField(partitionName);
    }

    public Set<String> getInstanceSet(String partitionName) {
        if (this.getIdealStateMode() == IdealStateModeProperty.AUTO || this.getIdealStateMode() == IdealStateModeProperty.AUTO_REBALANCE) {
            List<String> prefList = this._record.getListField(partitionName);
            if (prefList != null) {
                return new TreeSet<String>(prefList);
            }
            logger.warn((Object)(partitionName + " does NOT exist"));
            return Collections.emptySet();
        }
        if (this.getIdealStateMode() == IdealStateModeProperty.CUSTOMIZED) {
            Map<String, String> stateMap = this._record.getMapField(partitionName);
            if (stateMap != null) {
                return new TreeSet<String>(stateMap.keySet());
            }
            logger.warn((Object)(partitionName + " does NOT exist"));
            return Collections.emptySet();
        }
        logger.error((Object)("Invalid ideal state mode: " + this.getResourceName()));
        return Collections.emptySet();
    }

    public List<String> getPreferenceList(String partitionName) {
        List<String> instanceStateList = this._record.getListField(partitionName);
        if (instanceStateList != null) {
            return instanceStateList;
        }
        logger.warn((Object)("Resource key:" + partitionName + " does not have a pre-computed preference list."));
        return null;
    }

    public String getStateModelDefRef() {
        return this._record.getSimpleField(IdealStateProperty.STATE_MODEL_DEF_REF.toString());
    }

    public void setStateModelDefRef(String stateModel) {
        this._record.setSimpleField(IdealStateProperty.STATE_MODEL_DEF_REF.toString(), stateModel);
    }

    public void setNumPartitions(int numPartitions) {
        this._record.setSimpleField(IdealStateProperty.NUM_PARTITIONS.toString(), String.valueOf(numPartitions));
    }

    public int getNumPartitions() {
        String numPartitionStr = this._record.getSimpleField(IdealStateProperty.NUM_PARTITIONS.toString());
        try {
            return Integer.parseInt(numPartitionStr);
        }
        catch (Exception e) {
            logger.error((Object)("Can't parse number of partitions: " + numPartitionStr), (Throwable)e);
            return -1;
        }
    }

    public void setReplicas(String replicas) {
        this._record.setSimpleField(IdealStateProperty.REPLICAS.toString(), replicas);
    }

    public String getReplicas() {
        String replica = this._record.getSimpleField(IdealStateProperty.REPLICAS.toString());
        if (replica == null) {
            String firstPartition = null;
            switch (this.getIdealStateMode()) {
                case AUTO: {
                    replica = this._record.getListFields().size() == 0 ? "0" : Integer.toString((firstPartition = new ArrayList<String>(this._record.getListFields().keySet()).get(0)) == null ? 0 : this._record.getListField(firstPartition).size());
                    logger.warn((Object)("could NOT find number of replicas in idealState. Use size of the first list instead. replica: " + replica + ", 1st partition: " + firstPartition));
                    break;
                }
                case CUSTOMIZED: {
                    replica = this._record.getMapFields().size() == 0 ? "0" : Integer.toString((firstPartition = new ArrayList<String>(this._record.getMapFields().keySet()).get(0)) == null ? 0 : this._record.getMapField(firstPartition).size());
                    logger.warn((Object)("could NOT find replicas in idealState. Use size of the first map instead. replica: " + replica + ", 1st partition: " + firstPartition));
                    break;
                }
                default: {
                    replica = "0";
                    logger.error((Object)"could NOT determine replicas. set to 0");
                }
            }
        }
        return replica;
    }

    public void setStateModelFactoryName(String name) {
        this._record.setSimpleField(IdealStateProperty.STATE_MODEL_FACTORY_NAME.toString(), name);
    }

    public String getStateModelFactoryName() {
        String ftyName = this._record.getSimpleField(IdealStateProperty.STATE_MODEL_FACTORY_NAME.toString());
        if (ftyName == null) {
            ftyName = "DEFAULT";
        }
        return ftyName;
    }

    public int getRebalanceTimerPeriod() {
        if (this._record.getSimpleFields().containsKey(IdealStateProperty.REBALANCE_TIMER_PERIOD.toString())) {
            try {
                int result = Integer.parseInt(this._record.getSimpleField(IdealStateProperty.REBALANCE_TIMER_PERIOD.toString()));
                return result;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return -1;
    }

    @Override
    public boolean isValid() {
        if (this.getNumPartitions() < 0) {
            logger.error((Object)("idealState:" + this._record + " does not have number of partitions (was " + this.getNumPartitions() + ")."));
            return false;
        }
        if (this.getStateModelDefRef() == null) {
            logger.error((Object)("idealStates:" + this._record + " does not have state model definition."));
            return false;
        }
        if (this.getIdealStateMode() == IdealStateModeProperty.AUTO) {
            String replicaStr = this.getReplicas();
            if (replicaStr == null) {
                logger.error((Object)("invalid ideal-state. missing replicas in auto mode. record was: " + this._record));
                return false;
            }
            if (!replicaStr.equals(HelixConstants.StateModelToken.ANY_LIVEINSTANCE.toString())) {
                int replica = Integer.parseInt(replicaStr);
                Set<String> partitionSet = this.getPartitionSet();
                for (String partition : partitionSet) {
                    List<String> preferenceList = this.getPreferenceList(partition);
                    if (preferenceList != null && preferenceList.size() == replica) continue;
                    logger.error((Object)("invalid ideal-state. preference-list size not equals to replicas in auto mode. replica: " + replica + ", preference-list size: " + preferenceList.size() + ", record was: " + this._record));
                    return false;
                }
            }
        }
        return true;
    }

    public void setInstanceGroupTag(String groupTag) {
        this._record.setSimpleField(IdealStateProperty.INSTANCE_GROUP_TAG.toString(), groupTag);
    }

    public String getInstanceGroupTag() {
        return this._record.getSimpleField(IdealStateProperty.INSTANCE_GROUP_TAG.toString());
    }

    public static enum IdealStateModeProperty {
        AUTO,
        CUSTOMIZED,
        AUTO_REBALANCE;

    }

    public static enum IdealStateProperty {
        NUM_PARTITIONS,
        STATE_MODEL_DEF_REF,
        STATE_MODEL_FACTORY_NAME,
        REPLICAS,
        IDEAL_STATE_MODE,
        REBALANCE_TIMER_PERIOD,
        MAX_PARTITONS_PER_INSTANCE,
        INSTANCE_GROUP_TAG,
        REBALANCER_CLASS_NAME;

    }
}

