/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import java.util.Map;
import org.apache.helix.healthcheck.AggregationType;
import org.apache.log4j.Logger;

public class Stat {
    private static final Logger _logger = Logger.getLogger(Stat.class);
    public static final String OP_TYPE = "HTTP_OP";
    public static final String MEASUREMENT_TYPE = "MEASUREMENT";
    public static final String RESOURCE_NAME = "RESOURCE_NAME";
    public static final String PARTITION_NAME = "PARTITION_NAME";
    public static final String NODE_NAME = "NODE_NAME";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String RETURN_STATUS = "RETURN_STATUS";
    public static final String METRIC_NAME = "METRIC_NAME";
    public static final String AGG_TYPE = "AGG_TYPE";
    public String _opType;
    public String _measurementType;
    public String _resourceName;
    public String _partitionName;
    public String _nodeName;
    public String _returnStatus;
    public String _metricName;
    public String _aggTypeName;
    public String _timestamp;

    public Stat(String opType, String measurementType, String resourceName, String partitionName, String nodeName) {
        this(opType, measurementType, resourceName, partitionName, nodeName, null, null, null);
    }

    public Stat(String opType, String measurementType, String resourceName, String partitionName, String nodeName, String returnStatus, String metricName, AggregationType aggType) {
        this._opType = opType;
        this._measurementType = measurementType;
        this._resourceName = resourceName;
        this._partitionName = partitionName;
        this._nodeName = nodeName;
        this._returnStatus = returnStatus;
        this._metricName = metricName;
        this._aggTypeName = null;
        if (aggType != null) {
            this._aggTypeName = aggType.getName();
        }
        this._timestamp = String.valueOf(System.currentTimeMillis());
    }

    public Stat(Map<String, String> in) {
        this._opType = in.get(OP_TYPE);
        this._measurementType = in.get(MEASUREMENT_TYPE);
        this._resourceName = in.get(RESOURCE_NAME);
        this._partitionName = in.get(PARTITION_NAME);
        this._nodeName = in.get(NODE_NAME);
        this._timestamp = String.valueOf(System.currentTimeMillis());
    }

    public void setAggType(AggregationType aggType) {
        this._aggTypeName = aggType.getName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Stat)) {
            return false;
        }
        Stat other = (Stat)obj;
        if (!this._partitionName.equals(other._partitionName)) {
            return false;
        }
        if (!this._opType.equals(other._opType)) {
            return false;
        }
        if (!this._measurementType.equals(other._measurementType)) {
            return false;
        }
        if (!this._resourceName.equals(other._resourceName)) {
            return false;
        }
        return this._nodeName.equals(other._nodeName);
    }

    public int hashCode() {
        return (this._partitionName + this._opType + this._measurementType + this._resourceName + this._nodeName).hashCode();
    }

    public void addAlert(long value) {
    }

    public String toString() {
        return this._nodeName + "." + this._resourceName + "." + this._partitionName + "." + this._opType + "." + this._measurementType + "." + this._returnStatus + "." + this._metricName + "." + this._aggTypeName;
    }
}

