/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import java.util.Date;
import org.apache.helix.ZNRecord;
import org.apache.log4j.Logger;

@Deprecated
public class DefaultPerfCounters
extends ZNRecord {
    private static final Logger _logger = Logger.getLogger(DefaultPerfCounters.class);
    public static final String _availableCPUs = "availableCPUs";
    public static final String _freePhysicalMemory = "freePhysicalMemory";
    public static final String _totalJvmMemory = "totalJvmMemory";
    public static final String _freeJvmMemory = "freeJvmMemory";
    public static final String _averageSystemLoad = "averageSystemLoad";

    public DefaultPerfCounters(String instanceName, long availableCPUs, long freePhysicalMemory, long freeJvmMemory, long totalJvmMemory, double averageSystemLoad) {
        super("DefaultPerfCounters");
        this.setSimpleField("instanceName", instanceName);
        this.setSimpleField("createTime", new Date().toString());
        this.setSimpleField(_availableCPUs, "" + availableCPUs);
        this.setSimpleField(_freePhysicalMemory, "" + freePhysicalMemory);
        this.setSimpleField(_freeJvmMemory, "" + freeJvmMemory);
        this.setSimpleField(_totalJvmMemory, "" + totalJvmMemory);
        this.setSimpleField(_averageSystemLoad, "" + averageSystemLoad);
    }

    public long getAvailableCpus() {
        return this.getSimpleLongVal(_availableCPUs);
    }

    public double getAverageSystemLoad() {
        return this.getSimpleDoubleVal(_averageSystemLoad);
    }

    public long getTotalJvmMemory() {
        return this.getSimpleLongVal(_totalJvmMemory);
    }

    public long getFreeJvmMemory() {
        return this.getSimpleLongVal(_freeJvmMemory);
    }

    public long getFreePhysicalMemory() {
        return this.getSimpleLongVal(_freePhysicalMemory);
    }

    long getSimpleLongVal(String key) {
        String strVal = this.getSimpleField(key);
        if (strVal == null) {
            return 0L;
        }
        try {
            return Long.parseLong(strVal);
        }
        catch (Exception e) {
            _logger.warn((Object)e);
            return 0L;
        }
    }

    double getSimpleDoubleVal(String key) {
        String strVal = this.getSimpleField(key);
        if (strVal == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(strVal);
        }
        catch (Exception e) {
            _logger.warn((Object)e);
            return 0.0;
        }
    }
}

