/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.examples;

import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;

public class OnlineOfflineStateModelFactory
extends StateModelFactory<StateModel> {
    int _delay;

    public OnlineOfflineStateModelFactory(int delay) {
        this._delay = delay;
    }

    @Override
    public StateModel createNewStateModel(String stateUnitKey) {
        OnlineOfflineStateModel stateModel = new OnlineOfflineStateModel();
        stateModel.setDelay(this._delay);
        return stateModel;
    }

    public static class OnlineOfflineStateModel
    extends StateModel {
        int _transDelay = 0;

        public void setDelay(int delay) {
            this._transDelay = delay > 0 ? delay : 0;
        }

        public void onBecomeOnlineFromOffline(Message message, NotificationContext context) {
            System.out.println("OnlineOfflineStateModel.onBecomeOnlineFromOffline()");
            this.sleep();
        }

        public void onBecomeOfflineFromOnline(Message message, NotificationContext context) {
            System.out.println("OnlineOfflineStateModel.onBecomeOfflineFromOnline()");
            this.sleep();
        }

        public void onBecomeDroppedFromOffline(Message message, NotificationContext context) {
            System.out.println("OnlineOfflineStateModel.onBecomeDroppedFromOffline()");
            this.sleep();
        }

        private void sleep() {
            try {
                Thread.sleep(this._transDelay);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

