/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.StateModelDefinition;
import org.apache.log4j.Logger;

public class BestPossibleStateCalcStage
extends AbstractBaseStage {
    private static final Logger logger = Logger.getLogger((String)BestPossibleStateCalcStage.class.getName());

    @Override
    public void process(ClusterEvent event) throws Exception {
        long startTime = System.currentTimeMillis();
        logger.info((Object)"START BestPossibleStateCalcStage.process()");
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.toString());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.toString());
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        if (currentStateOutput == null || resourceMap == null || cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires CURRENT_STATE|RESOURCES|DataCache");
        }
        BestPossibleStateOutput bestPossibleStateOutput = this.compute(event, resourceMap, currentStateOutput);
        event.addAttribute(AttributeName.BEST_POSSIBLE_STATE.toString(), bestPossibleStateOutput);
        long endTime = System.currentTimeMillis();
        logger.info((Object)("END BestPossibleStateCalcStage.process(). took: " + (endTime - startTime) + " ms"));
    }

    private BestPossibleStateOutput compute(ClusterEvent event, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput) {
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        HelixManager manager = (HelixManager)event.getAttribute("helixmanager");
        BestPossibleStateOutput output = new BestPossibleStateOutput();
        for (String resourceName : resourceMap.keySet()) {
            String stateModelDefName;
            logger.debug((Object)("Processing resource:" + resourceName));
            Resource resource = resourceMap.get(resourceName);
            IdealState idealState = cache.getIdealState(resourceName);
            if (idealState == null) {
                logger.info((Object)("resource:" + resourceName + " does not exist anymore"));
                stateModelDefName = currentStateOutput.getResourceStateModelDef(resourceName);
                idealState = new IdealState(resourceName);
            } else {
                stateModelDefName = idealState.getStateModelDefRef();
            }
            StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
            if (idealState.getIdealStateMode() == IdealState.IdealStateModeProperty.AUTO_REBALANCE) {
                this.calculateAutoBalancedIdealState(cache, idealState, stateModelDef, currentStateOutput);
            }
            for (Partition partition : resource.getPartitions()) {
                Map<String, String> bestStateForPartition;
                Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resourceName, partition);
                Set<String> disabledInstancesForPartition = cache.getDisabledInstancesForPartition(partition.toString());
                if (idealState.getIdealStateMode() == IdealState.IdealStateModeProperty.CUSTOMIZED) {
                    Map<String, String> idealStateMap = idealState.getInstanceStateMap(partition.getPartitionName());
                    bestStateForPartition = this.computeCustomizedBestStateForPartition(cache, stateModelDef, idealStateMap, currentStateMap, disabledInstancesForPartition);
                } else {
                    List<String> instancePreferenceList = this.getPreferenceList(cache, partition, idealState, stateModelDef);
                    bestStateForPartition = this.computeAutoBestStateForPartition(cache, stateModelDef, instancePreferenceList, currentStateMap, disabledInstancesForPartition);
                }
                output.setState(resourceName, partition, bestStateForPartition);
            }
        }
        return output;
    }

    private void calculateAutoBalancedIdealState(ClusterDataCache cache, IdealState idealState, StateModelDefinition stateModelDef, CurrentStateOutput currentStateOutput) {
        String topStateValue = stateModelDef.getStatesPriorityList().get(0);
        Set<String> liveInstances = cache._liveInstanceMap.keySet();
        HashSet<String> taggedInstances = new HashSet<String>();
        if (idealState.getInstanceGroupTag() != null) {
            for (String instanceName : liveInstances) {
                if (!cache._instanceConfigMap.get(instanceName).containsTag(idealState.getInstanceGroupTag())) continue;
                taggedInstances.add(instanceName);
            }
        }
        if (taggedInstances.size() > 0) {
            logger.info((Object)("found the following instances with tag " + idealState.getResourceName() + " " + taggedInstances));
            liveInstances = taggedInstances;
        }
        int replicas = 1;
        try {
            replicas = Integer.parseInt(idealState.getReplicas());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        TreeMap<String, List<String>> defaultListFields = new TreeMap<String, List<String>>();
        ArrayList emptyList = new ArrayList(0);
        for (String partition : idealState.getPartitionSet()) {
            defaultListFields.put(partition, emptyList);
        }
        idealState.getRecord().setListFields(defaultListFields);
        if (liveInstances.size() == 0) {
            logger.info((Object)("No live instances, return. Idealstate : " + idealState.getResourceName()));
            return;
        }
        HashMap<String, List<String>> masterAssignmentMap = new HashMap<String, List<String>>();
        for (String instanceName : liveInstances) {
            masterAssignmentMap.put(instanceName, new ArrayList());
        }
        HashSet<String> orphanedPartitions = new HashSet<String>();
        orphanedPartitions.addAll(idealState.getPartitionSet());
        for (String liveInstanceName : liveInstances) {
            CurrentState currentState = cache.getCurrentState(liveInstanceName, cache.getLiveInstances().get(liveInstanceName).getSessionId()).get(idealState.getId());
            if (currentState == null) continue;
            Map<String, String> partitionStates = currentState.getPartitionStateMap();
            for (String partitionName : partitionStates.keySet()) {
                String state = partitionStates.get(partitionName);
                if (!state.equals(topStateValue)) continue;
                ((List)masterAssignmentMap.get(liveInstanceName)).add(partitionName);
                orphanedPartitions.remove(partitionName);
            }
        }
        ArrayList<String> orphanedPartitionsList = new ArrayList<String>();
        orphanedPartitionsList.addAll(orphanedPartitions);
        int maxPartitionsPerInstance = idealState.getMaxPartitionsPerInstance();
        this.normalizeAssignmentMap(masterAssignmentMap, orphanedPartitionsList, maxPartitionsPerInstance);
        idealState.getRecord().setListFields(this.generateListFieldFromMasterAssignment(masterAssignmentMap, replicas));
    }

    private void normalizeAssignmentMap(Map<String, List<String>> masterAssignmentMap, List<String> orphanPartitions, int maxPartitionsPerInstance) {
        int lastElementIndex;
        int targetPartitionNo;
        int i;
        int totalPartitions = 0;
        Object[] instanceNames = new String[masterAssignmentMap.size()];
        masterAssignmentMap.keySet().toArray(instanceNames);
        Arrays.sort(instanceNames);
        for (String key : masterAssignmentMap.keySet()) {
            totalPartitions += masterAssignmentMap.get(key).size();
            Collections.sort(masterAssignmentMap.get(key));
        }
        int partitionNumber = (totalPartitions += orphanPartitions.size()) / masterAssignmentMap.size();
        int leave = totalPartitions % masterAssignmentMap.size();
        for (i = 0; i < instanceNames.length; ++i) {
            targetPartitionNo = leave > 0 ? partitionNumber + 1 : partitionNumber;
            --leave;
            while (masterAssignmentMap.get(instanceNames[i]).size() > targetPartitionNo) {
                lastElementIndex = masterAssignmentMap.get(instanceNames[i]).size() - 1;
                orphanPartitions.add(masterAssignmentMap.get(instanceNames[i]).get(lastElementIndex));
                masterAssignmentMap.get(instanceNames[i]).remove(lastElementIndex);
            }
        }
        leave = totalPartitions % masterAssignmentMap.size();
        Collections.sort(orphanPartitions);
        for (i = 0; i < instanceNames.length; ++i) {
            targetPartitionNo = leave > 0 ? partitionNumber + 1 : partitionNumber;
            --leave;
            if (targetPartitionNo > maxPartitionsPerInstance) {
                targetPartitionNo = maxPartitionsPerInstance;
            }
            while (masterAssignmentMap.get(instanceNames[i]).size() < targetPartitionNo) {
                lastElementIndex = orphanPartitions.size() - 1;
                masterAssignmentMap.get(instanceNames[i]).add(orphanPartitions.get(lastElementIndex));
                orphanPartitions.remove(lastElementIndex);
            }
        }
        if (orphanPartitions.size() > 0) {
            logger.warn((Object)"orphanPartitions still contains elements");
        }
    }

    Map<String, List<String>> generateListFieldFromMasterAssignment(Map<String, List<String>> masterAssignmentMap, int replicas) {
        HashMap<String, List<String>> listFields = new HashMap<String, List<String>>();
        int slaves = replicas - 1;
        Object[] instanceNames = new String[masterAssignmentMap.size()];
        masterAssignmentMap.keySet().toArray(instanceNames);
        Arrays.sort(instanceNames);
        for (int i = 0; i < instanceNames.length; ++i) {
            Object instanceName = instanceNames[i];
            ArrayList<Object> otherInstances = new ArrayList<Object>(masterAssignmentMap.size() - 1);
            for (int x = 0; x < instanceNames.length - 1; ++x) {
                int index = (x + i + 1) % instanceNames.length;
                otherInstances.add(instanceNames[index]);
            }
            List<String> partitionList = masterAssignmentMap.get(instanceName);
            for (int j = 0; j < partitionList.size(); ++j) {
                String partitionName = partitionList.get(j);
                listFields.put(partitionName, new ArrayList());
                ((List)listFields.get(partitionName)).add(instanceName);
                int slavesCanAssign = Math.min(slaves, otherInstances.size());
                for (int k = 0; k < slavesCanAssign; ++k) {
                    int index = (j + k + 1) % otherInstances.size();
                    ((List)listFields.get(partitionName)).add(otherInstances.get(index));
                }
            }
        }
        return listFields;
    }

    private Map<String, String> computeAutoBestStateForPartition(ClusterDataCache cache, StateModelDefinition stateModelDef, List<String> instancePreferenceList, Map<String, String> currentStateMap, Set<String> disabledInstancesForPartition) {
        HashMap<String, String> instanceStateMap = new HashMap<String, String>();
        if (currentStateMap != null) {
            for (String instance : currentStateMap.keySet()) {
                if (!(instancePreferenceList != null && instancePreferenceList.contains(instance) || disabledInstancesForPartition.contains(instance))) {
                    instanceStateMap.put(instance, HelixDefinedState.DROPPED.toString());
                    continue;
                }
                if (currentStateMap.get(instance) != null && currentStateMap.get(instance).equals(HelixDefinedState.ERROR.toString()) || !disabledInstancesForPartition.contains(instance)) continue;
                instanceStateMap.put(instance, stateModelDef.getInitialState());
            }
        }
        if (instancePreferenceList == null) {
            return instanceStateMap;
        }
        List<String> statesPriorityList = stateModelDef.getStatesPriorityList();
        boolean[] assigned = new boolean[instancePreferenceList.size()];
        Map<String, LiveInstance> liveInstancesMap = cache.getLiveInstances();
        block3: for (String state : statesPriorityList) {
            String num = stateModelDef.getNumInstancesPerState(state);
            int stateCount = -1;
            if ("N".equals(num)) {
                HashSet<String> liveAndEnabled = new HashSet<String>(liveInstancesMap.keySet());
                liveAndEnabled.removeAll(disabledInstancesForPartition);
                stateCount = liveAndEnabled.size();
            } else if ("R".equals(num)) {
                stateCount = instancePreferenceList.size();
            } else {
                try {
                    stateCount = Integer.parseInt(num);
                }
                catch (Exception e) {
                    logger.error((Object)("Invalid count for state:" + state + " ,count=" + num));
                }
            }
            if (stateCount <= -1) continue;
            int count = 0;
            for (int i = 0; i < instancePreferenceList.size(); ++i) {
                boolean notInErrorState;
                String instanceName = instancePreferenceList.get(i);
                boolean bl = notInErrorState = currentStateMap == null || currentStateMap.get(instanceName) == null || !currentStateMap.get(instanceName).equals(HelixDefinedState.ERROR.toString());
                if (!liveInstancesMap.containsKey(instanceName) || assigned[i] || !notInErrorState || disabledInstancesForPartition.contains(instanceName)) continue;
                instanceStateMap.put(instanceName, state);
                assigned[i] = true;
                if (++count == stateCount) continue block3;
            }
        }
        return instanceStateMap;
    }

    private Map<String, String> computeCustomizedBestStateForPartition(ClusterDataCache cache, StateModelDefinition stateModelDef, Map<String, String> idealStateMap, Map<String, String> currentStateMap, Set<String> disabledInstancesForPartition) {
        HashMap<String, String> instanceStateMap = new HashMap<String, String>();
        if (currentStateMap != null) {
            for (String instance : currentStateMap.keySet()) {
                if (!(idealStateMap != null && idealStateMap.containsKey(instance) || disabledInstancesForPartition.contains(instance))) {
                    instanceStateMap.put(instance, HelixDefinedState.DROPPED.toString());
                    continue;
                }
                if (currentStateMap.get(instance) != null && currentStateMap.get(instance).equals(HelixDefinedState.ERROR.toString()) || !disabledInstancesForPartition.contains(instance)) continue;
                instanceStateMap.put(instance, stateModelDef.getInitialState());
            }
        }
        if (idealStateMap == null) {
            return instanceStateMap;
        }
        Map<String, LiveInstance> liveInstancesMap = cache.getLiveInstances();
        for (String instance : idealStateMap.keySet()) {
            boolean notInErrorState;
            boolean bl = notInErrorState = currentStateMap == null || currentStateMap.get(instance) == null || !currentStateMap.get(instance).equals(HelixDefinedState.ERROR.toString());
            if (!liveInstancesMap.containsKey(instance) || !notInErrorState || disabledInstancesForPartition.contains(instance)) continue;
            instanceStateMap.put(instance, idealStateMap.get(instance));
        }
        return instanceStateMap;
    }

    private List<String> getPreferenceList(ClusterDataCache cache, Partition resource, IdealState idealState, StateModelDefinition stateModelDef) {
        List<String> listField = idealState.getPreferenceList(resource.getPartitionName());
        if (listField != null && listField.size() == 1 && HelixConstants.StateModelToken.ANY_LIVEINSTANCE.toString().equals(listField.get(0))) {
            Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
            ArrayList<String> prefList = new ArrayList<String>(liveInstances.keySet());
            Collections.sort(prefList);
            return prefList;
        }
        return listField;
    }
}

