/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.alerts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Tuple<T> {
    List<T> elements = new ArrayList<T>();

    public int size() {
        return this.elements.size();
    }

    public void add(T entry) {
        this.elements.add(entry);
    }

    public void addAll(Tuple<T> incoming) {
        this.elements.addAll(incoming.getElements());
    }

    public Iterator<T> iterator() {
        return this.elements.listIterator();
    }

    public T getElement(int ind) {
        return this.elements.get(ind);
    }

    public List<T> getElements() {
        return this.elements;
    }

    public void clear() {
        this.elements.clear();
    }

    public static Tuple<String> fromString(String in) {
        Tuple<String> tup = new Tuple<String>();
        if (in.length() > 0) {
            String[] elements;
            for (String element : elements = in.split(",")) {
                tup.add(element);
            }
        }
        return tup;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        Iterator<T> it = this.iterator();
        boolean outEmpty = true;
        while (it.hasNext()) {
            if (!outEmpty) {
                out.append(",");
            }
            out.append(it.next());
            outEmpty = false;
        }
        return out.toString();
    }
}

