/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.alerts;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.alerts.Aggregator;
import org.apache.helix.alerts.ExpressionParser;
import org.apache.helix.alerts.Stat;
import org.apache.helix.alerts.Tuple;
import org.apache.helix.controller.stages.HealthDataCache;
import org.apache.helix.model.PersistentStats;
import org.apache.log4j.Logger;

public class StatsHolder {
    private static final Logger logger = Logger.getLogger((String)StatsHolder.class.getName());
    public static final String VALUE_NAME = "value";
    public static final String TIMESTAMP_NAME = "TimeStamp";
    HelixDataAccessor _accessor;
    HealthDataCache _cache;
    Map<String, Map<String, String>> _statMap;
    Map<String, Map<String, MatchResult>> _statAlertMatchResult;
    private PropertyKey.Builder _keyBuilder;

    public StatsHolder(HelixManager manager, HealthDataCache cache) {
        this._accessor = manager.getHelixDataAccessor();
        this._cache = cache;
        this._keyBuilder = new PropertyKey.Builder(manager.getClusterName());
        this.updateCache(this._cache);
        this._statAlertMatchResult = new HashMap<String, Map<String, MatchResult>>();
    }

    public void refreshStats() {
        logger.info((Object)"Refreshing cached stats");
        this._cache.refresh(this._accessor);
        this.updateCache(this._cache);
    }

    public void persistStats() {
        PersistentStats stats = (PersistentStats)this._accessor.getProperty(this._keyBuilder.persistantStat());
        if (stats == null) {
            stats = new PersistentStats("PersistentStats");
        }
        stats.getRecord().setMapFields(this._statMap);
        boolean retVal = this._accessor.setProperty(this._keyBuilder.persistantStat(), stats);
    }

    public void getStatsFromCache(boolean refresh) {
        PersistentStats persistentStatRecord;
        long refreshStartTime = System.currentTimeMillis();
        if (refresh) {
            this._cache.refresh(this._accessor);
        }
        this._statMap = (persistentStatRecord = this._cache.getPersistentStats()) != null ? persistentStatRecord.getMapFields() : new HashMap<String, Map<String, String>>();
        System.out.println("Refresh stats done: " + (System.currentTimeMillis() - refreshStartTime));
    }

    public Iterator<String> getAllStats() {
        return null;
    }

    public Map<String, String> mergeStats(String statName, Map<String, String> existingStat, Map<String, String> incomingStat) throws HelixException {
        if (existingStat == null) {
            throw new HelixException("existing stat for merge is null");
        }
        if (incomingStat == null) {
            throw new HelixException("incoming stat for merge is null");
        }
        String aggTypeStr = ExpressionParser.getAggregatorStr(statName);
        String[] aggArgs = ExpressionParser.getAggregatorArgs(statName);
        Aggregator agg = ExpressionParser.getAggregator(aggTypeStr);
        String existingTime = existingStat.get(TIMESTAMP_NAME);
        String existingVal = existingStat.get(VALUE_NAME);
        String incomingTime = incomingStat.get(TIMESTAMP_NAME);
        String incomingVal = incomingStat.get(VALUE_NAME);
        Tuple<String> existingTimeTuple = existingTime != null ? Tuple.fromString(existingTime) : null;
        Tuple<String> existingValueTuple = existingVal != null ? Tuple.fromString(existingVal) : null;
        Tuple<String> incomingTimeTuple = incomingTime != null ? Tuple.fromString(incomingTime) : null;
        Tuple<String> incomingValueTuple = incomingVal != null ? Tuple.fromString(incomingVal) : null;
        agg.merge(existingValueTuple, incomingValueTuple, existingTimeTuple, incomingTimeTuple, aggArgs);
        HashMap<String, String> mergedMap = new HashMap<String, String>();
        if (existingTimeTuple.size() == 0) {
            throw new HelixException("merged time tuple has size zero");
        }
        if (existingValueTuple.size() == 0) {
            throw new HelixException("merged value tuple has size zero");
        }
        mergedMap.put(TIMESTAMP_NAME, existingTimeTuple.toString());
        mergedMap.put(VALUE_NAME, existingValueTuple.toString());
        return mergedMap;
    }

    public void applyStat(String incomingStatName, Map<String, String> statFields) {
        HashMap<String, Map<String, String>> pendingAdds = new HashMap<String, Map<String, String>>();
        if (!this._statAlertMatchResult.containsKey(incomingStatName)) {
            this._statAlertMatchResult.put(incomingStatName, new HashMap());
        }
        Map<String, MatchResult> resultMap = this._statAlertMatchResult.get(incomingStatName);
        for (String key : this._statMap.keySet()) {
            if (resultMap.containsKey(key)) {
                MatchResult cachedMatchResult = resultMap.get(key);
                if (cachedMatchResult == MatchResult.EXACTMATCH) {
                    this.processExactMatch(key, statFields);
                    continue;
                }
                if (cachedMatchResult != MatchResult.WILDCARDMATCH) continue;
                this.processWildcardMatch(incomingStatName, key, statFields, pendingAdds);
                continue;
            }
            if (ExpressionParser.isIncomingStatExactMatch(key, incomingStatName)) {
                this.processExactMatch(key, statFields);
                resultMap.put(key, MatchResult.EXACTMATCH);
                continue;
            }
            if (ExpressionParser.isIncomingStatWildcardMatch(key, incomingStatName)) {
                this.processWildcardMatch(incomingStatName, key, statFields, pendingAdds);
                resultMap.put(key, MatchResult.WILDCARDMATCH);
                continue;
            }
            resultMap.put(key, MatchResult.NOMATCH);
        }
        this._statMap.putAll(pendingAdds);
    }

    void processExactMatch(String key, Map<String, String> statFields) {
        Map<String, String> mergedStat = this.mergeStats(key, this._statMap.get(key), statFields);
        this._statMap.put(key, mergedStat);
    }

    void processWildcardMatch(String incomingStatName, String key, Map<String, String> statFields, Map<String, Map<String, String>> pendingAdds) {
        String statToAdd = ExpressionParser.getWildcardStatSubstitution(key, incomingStatName);
        if (!this._statMap.containsKey(statToAdd) && !pendingAdds.containsKey(statToAdd)) {
            Map<String, String> mergedStat = this.mergeStats(statToAdd, StatsHolder.getEmptyStat(), statFields);
            pendingAdds.put(statToAdd, mergedStat);
        }
    }

    public void addStat(String exp) throws HelixException {
        String[] parsedStats;
        this.refreshStats();
        for (String stat : parsedStats = ExpressionParser.getBaseStats(exp)) {
            if (this._statMap.containsKey(stat)) {
                logger.debug((Object)("Stat " + stat + " already exists; not adding"));
                continue;
            }
            this._statMap.put(stat, StatsHolder.getEmptyStat());
        }
    }

    public static Map<String, Map<String, String>> parseStat(String exp) throws HelixException {
        String[] parsedStats = ExpressionParser.getBaseStats(exp);
        HashMap<String, Map<String, String>> statMap = new HashMap<String, Map<String, String>>();
        for (String stat : parsedStats) {
            if (statMap.containsKey(stat)) {
                logger.debug((Object)("Stat " + stat + " already exists; not adding"));
                continue;
            }
            statMap.put(stat, StatsHolder.getEmptyStat());
        }
        return statMap;
    }

    public static Map<String, String> getEmptyStat() {
        HashMap<String, String> statFields = new HashMap<String, String>();
        statFields.put(TIMESTAMP_NAME, "");
        statFields.put(VALUE_NAME, "");
        return statFields;
    }

    public List<Stat> getStatsList() {
        LinkedList<Stat> stats = new LinkedList<Stat>();
        for (String stat : this._statMap.keySet()) {
            Map<String, String> statFields = this._statMap.get(stat);
            Tuple<String> valTup = Tuple.fromString(statFields.get(VALUE_NAME));
            Tuple<String> timeTup = Tuple.fromString(statFields.get(TIMESTAMP_NAME));
            Stat s = new Stat(stat, valTup, timeTup);
            stats.add(s);
        }
        return stats;
    }

    public Map<String, Tuple<String>> getStatsMap() {
        HashMap<String, Tuple<String>> stats = new HashMap<String, Tuple<String>>();
        for (String stat : this._statMap.keySet()) {
            Map<String, String> statFields = this._statMap.get(stat);
            Tuple<String> valTup = Tuple.fromString(statFields.get(VALUE_NAME));
            Tuple<String> timeTup = Tuple.fromString(statFields.get(TIMESTAMP_NAME));
            stats.put(stat, valTup);
        }
        return stats;
    }

    public void updateCache(HealthDataCache cache) {
        this._cache = cache;
        PersistentStats persistentStatRecord = this._cache.getPersistentStats();
        this._statMap = persistentStatRecord != null ? persistentStatRecord.getMapFields() : new HashMap<String, Map<String, String>>();
    }

    static enum MatchResult {
        WILDCARDMATCH,
        EXACTMATCH,
        NOMATCH;

    }
}

