/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.alerts;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.HelixException;
import org.apache.helix.alerts.AlertComparator;
import org.apache.helix.alerts.ExpressionParser;
import org.apache.helix.alerts.GreaterAlertComparator;
import org.apache.helix.manager.zk.DefaultParticipantErrorMessageHandlerFactory;
import org.apache.log4j.Logger;

public class AlertParser {
    private static Logger logger = Logger.getLogger(AlertParser.class);
    public static final String EXPRESSION_NAME = "EXP";
    public static final String COMPARATOR_NAME = "CMP";
    public static final String CONSTANT_NAME = "CON";
    public static final String ACTION_NAME = "ACTION";
    static Map<String, AlertComparator> comparatorMap = new HashMap<String, AlertComparator>();

    private static void addComparatorEntry(String label, AlertComparator comp) {
        if (!comparatorMap.containsKey(label)) {
            comparatorMap.put(label, comp);
        }
        logger.info((Object)("Adding comparator: " + comp));
    }

    public static AlertComparator getComparator(String compName) {
        if (!comparatorMap.containsKey(compName = compName.replaceAll("\\s+", ""))) {
            throw new HelixException("Comparator type <" + compName + "> unknown");
        }
        return comparatorMap.get(compName);
    }

    public static String getComponent(String component, String alert) throws HelixException {
        int expStartPos = alert.indexOf(component);
        if (expStartPos < 0) {
            throw new HelixException(alert + " does not contain component " + component);
        }
        int expEndPos = expStartPos += component.length() + 1;
        int openParenCount = 1;
        while (openParenCount > 0) {
            if (alert.charAt(expEndPos) == '(') {
                ++openParenCount;
            } else if (alert.charAt(expEndPos) == ')') {
                --openParenCount;
            }
            ++expEndPos;
        }
        if (openParenCount != 0) {
            throw new HelixException(alert + " does not contain valid " + component + " component, " + "parentheses do not close");
        }
        return alert.substring(expStartPos, expEndPos - 1);
    }

    public static boolean validateAlert(String alert) throws HelixException {
        alert = alert.replaceAll("\\s+", "");
        String exp = AlertParser.getComponent(EXPRESSION_NAME, alert);
        String cmp = AlertParser.getComponent(COMPARATOR_NAME, alert);
        String val = AlertParser.getComponent(CONSTANT_NAME, alert);
        logger.debug((Object)("exp: " + exp));
        logger.debug((Object)("cmp: " + cmp));
        logger.debug((Object)("val: " + val));
        ExpressionParser.validateExpression(exp);
        if (!comparatorMap.containsKey(cmp.toUpperCase())) {
            throw new HelixException("Unknown comparator type " + cmp);
        }
        String actionValue = null;
        try {
            actionValue = AlertParser.getComponent(ACTION_NAME, alert);
        }
        catch (Exception e) {
            logger.info((Object)("No action specified in " + alert));
        }
        if (actionValue != null) {
            AlertParser.validateActionValue(actionValue);
        }
        return false;
    }

    public static void validateActionValue(String actionValue) {
        try {
            DefaultParticipantErrorMessageHandlerFactory.ActionOnError actionVal = DefaultParticipantErrorMessageHandlerFactory.ActionOnError.valueOf(actionValue);
        }
        catch (Exception e) {
            String validActions = "";
            for (DefaultParticipantErrorMessageHandlerFactory.ActionOnError action : DefaultParticipantErrorMessageHandlerFactory.ActionOnError.values()) {
                validActions = validActions + (Object)((Object)action) + " ";
            }
            throw new HelixException("Unknown cmd type " + actionValue + ", valid types : " + validActions);
        }
    }

    static {
        AlertParser.addComparatorEntry("GREATER", new GreaterAlertComparator());
    }
}

