/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.stream;

import io.netty.buffer.ChannelBuffers;
import io.netty.handler.stream.ChunkedInput;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class ChunkedStream
implements ChunkedInput {
    static final int DEFAULT_CHUNK_SIZE = 8192;
    private final PushbackInputStream in;
    private final int chunkSize;
    private volatile long offset;

    public ChunkedStream(InputStream in) {
        this(in, 8192);
    }

    public ChunkedStream(InputStream in, int chunkSize) {
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize: " + chunkSize + " (expected: a positive integer)");
        }
        this.in = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in);
        this.chunkSize = chunkSize;
    }

    public long getTransferredBytes() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        int b = this.in.read();
        if (b < 0) {
            return true;
        }
        this.in.unread(b);
        return false;
    }

    @Override
    public void close() throws Exception {
        this.in.close();
    }

    @Override
    public Object nextChunk() throws Exception {
        int localReadBytes;
        if (this.isEndOfInput()) {
            return null;
        }
        int availableBytes = this.in.available();
        int chunkSize = availableBytes <= 0 ? this.chunkSize : Math.min(this.chunkSize, this.in.available());
        byte[] chunk = new byte[chunkSize];
        int readBytes = 0;
        while ((localReadBytes = this.in.read(chunk, readBytes, chunkSize - readBytes)) >= 0) {
            this.offset += (long)localReadBytes;
            if ((readBytes += localReadBytes) != chunkSize) continue;
            break;
        }
        return ChannelBuffers.wrappedBuffer(chunk, 0, readBytes);
    }
}

