/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.execution;

import io.netty.channel.ChannelDownstreamHandler;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelState;
import io.netty.channel.ChannelStateEvent;
import io.netty.channel.ChannelUpstreamHandler;
import io.netty.handler.execution.ChannelDownstreamEventRunnable;
import io.netty.handler.execution.ChannelUpstreamEventRunnable;
import io.netty.util.ExternalResourceReleasable;
import io.netty.util.internal.ExecutorUtil;
import java.util.concurrent.Executor;

@ChannelHandler.Sharable
public class ExecutionHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler,
ExternalResourceReleasable {
    private final Executor executor;
    private final boolean handleDownstream;

    public ExecutionHandler(Executor executor) {
        this(executor, false);
    }

    public ExecutionHandler(Executor executor, boolean handleDownstream) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        this.executor = executor;
        this.handleDownstream = handleDownstream;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void releaseExternalResources() {
        Executor executor = this.getExecutor();
        ExecutorUtil.terminate(executor);
        if (executor instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)executor)).releaseExternalResources();
        }
    }

    @Override
    public void handleUpstream(ChannelHandlerContext context, ChannelEvent e) throws Exception {
        this.executor.execute(new ChannelUpstreamEventRunnable(context, e));
    }

    @Override
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (!this.handleReadSuspend(ctx, e)) {
            if (this.handleDownstream) {
                this.executor.execute(new ChannelDownstreamEventRunnable(ctx, e));
            } else {
                ctx.sendDownstream(e);
            }
        }
    }

    protected boolean handleReadSuspend(ChannelHandlerContext ctx, ChannelEvent e) {
        ChannelStateEvent cse;
        if (e instanceof ChannelStateEvent && (cse = (ChannelStateEvent)e).getState() == ChannelState.INTEREST_OPS && ((Integer)cse.getValue() & 1) != 0) {
            boolean readSuspended;
            boolean bl = readSuspended = ctx.getAttachment() != null;
            if (readSuspended) {
                e.getFuture().setSuccess();
                return true;
            }
        }
        return false;
    }
}

