/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ChannelBuffer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.compression.ZlibDecoder;
import io.netty.handler.codec.embedder.DecoderEmbedder;
import io.netty.handler.codec.frame.FrameDecoder;
import io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import io.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import io.netty.handler.codec.spdy.DefaultSpdyPingFrame;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdySettingsFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyHeaderBlock;
import io.netty.handler.codec.spdy.SpdyProtocolException;

public class SpdyFrameDecoder
extends FrameDecoder {
    private final int maxChunkSize;
    private final int maxFrameSize;
    private final int maxHeaderSize;
    private final DecoderEmbedder<ChannelBuffer> headerBlockDecompressor = new DecoderEmbedder(new ZlibDecoder(SpdyCodecUtil.SPDY_DICT));

    public SpdyFrameDecoder() {
        this(8192, 65536, 16384);
    }

    public SpdyFrameDecoder(int maxChunkSize, int maxFrameSize, int maxHeaderSize) {
        super(true);
        if (maxChunkSize <= 0) {
            throw new IllegalArgumentException("maxChunkSize must be a positive integer: " + maxChunkSize);
        }
        if (maxFrameSize <= 0) {
            throw new IllegalArgumentException("maxFrameSize must be a positive integer: " + maxFrameSize);
        }
        if (maxHeaderSize <= 0) {
            throw new IllegalArgumentException("maxHeaderSize must be a positive integer: " + maxHeaderSize);
        }
        this.maxChunkSize = maxChunkSize;
        this.maxFrameSize = maxFrameSize;
        this.maxHeaderSize = maxHeaderSize;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < 8) {
            return null;
        }
        int frameOffset = buffer.readerIndex();
        int lengthOffset = frameOffset + 5;
        int dataLength = SpdyCodecUtil.getUnsignedMedium(buffer, lengthOffset);
        int frameLength = 8 + dataLength;
        if (frameLength > this.maxFrameSize) {
            throw new SpdyProtocolException("Frame length exceeds " + this.maxFrameSize + ": " + frameLength);
        }
        if (buffer.readableBytes() < frameLength) {
            return null;
        }
        boolean control = (buffer.getByte(frameOffset) & 0x80) != 0;
        int flagsOffset = frameOffset + 4;
        byte flags = buffer.getByte(flagsOffset);
        if (control) {
            int version = SpdyCodecUtil.getUnsignedShort(buffer, frameOffset) & Short.MAX_VALUE;
            if (version != 2) {
                buffer.skipBytes(frameLength);
                throw new SpdyProtocolException("Unsupported version: " + version);
            }
            int typeOffset = frameOffset + 2;
            int type = SpdyCodecUtil.getUnsignedShort(buffer, typeOffset);
            buffer.skipBytes(8);
            return this.decodeControlFrame(type, flags, buffer.readBytes(dataLength));
        }
        int streamID = SpdyCodecUtil.getUnsignedInt(buffer, frameOffset);
        buffer.skipBytes(8);
        int numFrames = dataLength / this.maxChunkSize;
        if (dataLength % this.maxChunkSize != 0) {
            ++numFrames;
        }
        SpdyDataFrame[] frames = new SpdyDataFrame[numFrames];
        for (int i = 0; i < numFrames; ++i) {
            int chunkSize = Math.min(this.maxChunkSize, dataLength);
            DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(streamID);
            spdyDataFrame.setCompressed((flags & 2) != 0);
            spdyDataFrame.setData(buffer.readBytes(chunkSize));
            if ((dataLength -= chunkSize) == 0) {
                spdyDataFrame.setLast((flags & 1) != 0);
            }
            frames[i] = spdyDataFrame;
        }
        return frames;
    }

    private Object decodeControlFrame(int type, byte flags, ChannelBuffer data) throws Exception {
        switch (type) {
            case 1: {
                if (data.readableBytes() < 12) {
                    throw new SpdyProtocolException("Received invalid SYN_STREAM control frame");
                }
                int streamID = SpdyCodecUtil.getUnsignedInt(data, data.readerIndex());
                int associatedToStreamID = SpdyCodecUtil.getUnsignedInt(data, data.readerIndex() + 4);
                byte priority = (byte)(data.getByte(data.readerIndex() + 8) >> 6 & 3);
                data.skipBytes(10);
                DefaultSpdySynStreamFrame spdySynStreamFrame = new DefaultSpdySynStreamFrame(streamID, associatedToStreamID, priority);
                boolean last = (flags & 1) != 0;
                boolean unid = (flags & 2) != 0;
                spdySynStreamFrame.setLast(last);
                spdySynStreamFrame.setUnidirectional(unid);
                this.decodeHeaderBlock(spdySynStreamFrame, this.decompress(data));
                return spdySynStreamFrame;
            }
            case 2: {
                if (data.readableBytes() < 8) {
                    throw new SpdyProtocolException("Received invalid SYN_REPLY control frame");
                }
                int streamID = SpdyCodecUtil.getUnsignedInt(data, data.readerIndex());
                data.skipBytes(6);
                DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamID);
                boolean last = (flags & 1) != 0;
                spdySynReplyFrame.setLast(last);
                this.decodeHeaderBlock(spdySynReplyFrame, this.decompress(data));
                return spdySynReplyFrame;
            }
            case 3: {
                if (flags != 0 || data.readableBytes() != 8) {
                    throw new SpdyProtocolException("Received invalid RST_STREAM control frame");
                }
                int streamID = SpdyCodecUtil.getUnsignedInt(data, data.readerIndex());
                int statusCode = SpdyCodecUtil.getSignedInt(data, data.readerIndex() + 4);
                if (statusCode == 0) {
                    throw new SpdyProtocolException("Received invalid RST_STREAM status code");
                }
                return new DefaultSpdyRstStreamFrame(streamID, statusCode);
            }
            case 4: {
                if (data.readableBytes() < 4) {
                    throw new SpdyProtocolException("Received invalid SETTINGS control frame");
                }
                int numEntries = SpdyCodecUtil.getUnsignedInt(data, data.readerIndex());
                if (numEntries > 0x1FFFFF || data.readableBytes() != numEntries * 8 + 4) {
                    throw new SpdyProtocolException("Received invalid SETTINGS control frame");
                }
                data.skipBytes(4);
                DefaultSpdySettingsFrame spdySettingsFrame = new DefaultSpdySettingsFrame();
                boolean clear = (flags & 1) != 0;
                spdySettingsFrame.setClearPreviouslyPersistedSettings(clear);
                for (int i = 0; i < numEntries; ++i) {
                    int ID = data.readByte() & 0xFF | (data.readByte() & 0xFF) << 8 | (data.readByte() & 0xFF) << 16;
                    byte ID_flags = data.readByte();
                    int value = SpdyCodecUtil.getSignedInt(data, data.readerIndex());
                    data.skipBytes(4);
                    if (spdySettingsFrame.isSet(ID)) continue;
                    boolean persistVal = (ID_flags & 1) != 0;
                    boolean persisted = (ID_flags & 2) != 0;
                    spdySettingsFrame.setValue(ID, value, persistVal, persisted);
                }
                return spdySettingsFrame;
            }
            case 5: {
                if (data.readableBytes() != 0) {
                    throw new SpdyProtocolException("Received invalid NOOP control frame");
                }
                return null;
            }
            case 6: {
                if (data.readableBytes() != 4) {
                    throw new SpdyProtocolException("Received invalid PING control frame");
                }
                int ID = SpdyCodecUtil.getSignedInt(data, data.readerIndex());
                return new DefaultSpdyPingFrame(ID);
            }
            case 7: {
                if (data.readableBytes() != 4) {
                    throw new SpdyProtocolException("Received invalid GOAWAY control frame");
                }
                int lastGoodStreamID = SpdyCodecUtil.getUnsignedInt(data, data.readerIndex());
                return new DefaultSpdyGoAwayFrame(lastGoodStreamID);
            }
            case 8: {
                if (data.readableBytes() == 4) {
                    int streamID = SpdyCodecUtil.getUnsignedInt(data, data.readerIndex());
                    return new DefaultSpdyHeadersFrame(streamID);
                }
                if (data.readableBytes() < 8) {
                    throw new SpdyProtocolException("Received invalid HEADERS control frame");
                }
                int streamID = SpdyCodecUtil.getUnsignedInt(data, data.readerIndex());
                data.skipBytes(6);
                DefaultSpdyHeadersFrame spdyHeadersFrame = new DefaultSpdyHeadersFrame(streamID);
                this.decodeHeaderBlock(spdyHeadersFrame, this.decompress(data));
                return spdyHeadersFrame;
            }
            case 9: {
                return null;
            }
        }
        return null;
    }

    private ChannelBuffer decompress(ChannelBuffer compressed) throws Exception {
        if (compressed.readableBytes() == 2 && compressed.getShort(compressed.readerIndex()) == 0) {
            return compressed;
        }
        this.headerBlockDecompressor.offer(compressed);
        return (ChannelBuffer)this.headerBlockDecompressor.poll();
    }

    private void decodeHeaderBlock(SpdyHeaderBlock headerFrame, ChannelBuffer headerBlock) throws Exception {
        if (headerBlock.readableBytes() < 2) {
            throw new SpdyProtocolException("Received invalid header block");
        }
        int headerSize = 0;
        int numEntries = SpdyCodecUtil.getUnsignedShort(headerBlock, headerBlock.readerIndex());
        headerBlock.skipBytes(2);
        for (int i = 0; i < numEntries; ++i) {
            if (headerBlock.readableBytes() < 2) {
                throw new SpdyProtocolException("Received invalid header block");
            }
            int nameLength = SpdyCodecUtil.getUnsignedShort(headerBlock, headerBlock.readerIndex());
            headerBlock.skipBytes(2);
            if (nameLength == 0) {
                headerFrame.setInvalid();
                return;
            }
            if ((headerSize += nameLength) > this.maxHeaderSize) {
                throw new SpdyProtocolException("Header block exceeds " + this.maxHeaderSize);
            }
            if (headerBlock.readableBytes() < nameLength) {
                throw new SpdyProtocolException("Received invalid header block");
            }
            byte[] nameBytes = new byte[nameLength];
            headerBlock.readBytes(nameBytes);
            String name = new String(nameBytes, "UTF-8");
            if (headerFrame.containsHeader(name)) {
                throw new SpdyProtocolException("Received duplicate header name: " + name);
            }
            if (headerBlock.readableBytes() < 2) {
                throw new SpdyProtocolException("Received invalid header block");
            }
            int valueLength = SpdyCodecUtil.getUnsignedShort(headerBlock, headerBlock.readerIndex());
            headerBlock.skipBytes(2);
            if (valueLength == 0) {
                headerFrame.setInvalid();
                return;
            }
            if ((headerSize += valueLength) > this.maxHeaderSize) {
                throw new SpdyProtocolException("Header block exceeds " + this.maxHeaderSize);
            }
            if (headerBlock.readableBytes() < valueLength) {
                throw new SpdyProtocolException("Received invalid header block");
            }
            byte[] valueBytes = new byte[valueLength];
            headerBlock.readBytes(valueBytes);
            int index = 0;
            int offset = 0;
            while (index < valueBytes.length) {
                while (index < valueBytes.length && valueBytes[index] != 0) {
                    ++index;
                }
                if (index < valueBytes.length && valueBytes[index + 1] == 0) {
                    headerFrame.setInvalid();
                    return;
                }
                String value = new String(valueBytes, offset, index - offset, "UTF-8");
                headerFrame.addHeader(name, value);
                offset = ++index;
            }
        }
    }
}

