/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.netty.util.internal.StringUtil;

public class DefaultSpdyRstStreamFrame
implements SpdyRstStreamFrame {
    private int streamID;
    private SpdyStreamStatus status;

    public DefaultSpdyRstStreamFrame(int streamID, int statusCode) {
        this(streamID, SpdyStreamStatus.valueOf(statusCode));
    }

    public DefaultSpdyRstStreamFrame(int streamID, SpdyStreamStatus status) {
        this.setStreamID(streamID);
        this.setStatus(status);
    }

    @Override
    public int getStreamID() {
        return this.streamID;
    }

    @Override
    public void setStreamID(int streamID) {
        if (streamID <= 0) {
            throw new IllegalArgumentException("Stream-ID must be positive: " + streamID);
        }
        this.streamID = streamID;
    }

    @Override
    public SpdyStreamStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(SpdyStreamStatus status) {
        this.status = status;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Stream-ID = ");
        buf.append(this.streamID);
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Status: ");
        buf.append(this.status.toString());
        return buf.toString();
    }
}

