/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBuffers;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.util.internal.StringUtil;

public class DefaultSpdyDataFrame
implements SpdyDataFrame {
    private int streamID;
    private boolean last;
    private boolean compressed;
    private ChannelBuffer data = ChannelBuffers.EMPTY_BUFFER;

    public DefaultSpdyDataFrame(int streamID) {
        this.setStreamID(streamID);
    }

    @Override
    public int getStreamID() {
        return this.streamID;
    }

    @Override
    public void setStreamID(int streamID) {
        if (streamID <= 0) {
            throw new IllegalArgumentException("Stream-ID must be positive: " + streamID);
        }
        this.streamID = streamID;
    }

    @Override
    public boolean isLast() {
        return this.last;
    }

    @Override
    public void setLast(boolean last) {
        this.last = last;
    }

    @Override
    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    @Override
    public ChannelBuffer getData() {
        return this.data;
    }

    @Override
    public void setData(ChannelBuffer data) {
        if (data == null) {
            data = ChannelBuffers.EMPTY_BUFFER;
        }
        if (data.readableBytes() > 0xFFFFFF) {
            throw new IllegalArgumentException("data payload cannot exceed 16777215 bytes");
        }
        this.data = data;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(last: ");
        buf.append(this.isLast());
        buf.append("; compressed: ");
        buf.append(this.isCompressed());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Stream-ID = ");
        buf.append(this.streamID);
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Size = ");
        buf.append(this.data.readableBytes());
        return buf.toString();
    }
}

