/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import java.util.Map;

public abstract class WebSocketClientHandshaker {
    private final URI webSocketUrl;
    private final WebSocketVersion version;
    private boolean handshakeComplete;
    private final String expectedSubprotocol;
    private String actualSubprotocol;
    protected final Map<String, String> customHeaders;

    public WebSocketClientHandshaker(URI webSocketUrl, WebSocketVersion version, String subprotocol, Map<String, String> customHeaders) {
        this.webSocketUrl = webSocketUrl;
        this.version = version;
        this.expectedSubprotocol = subprotocol;
        this.customHeaders = customHeaders;
    }

    public URI getWebSocketUrl() {
        return this.webSocketUrl;
    }

    public WebSocketVersion getVersion() {
        return this.version;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    protected void setHandshakeComplete() {
        this.handshakeComplete = true;
    }

    public String getExpectedSubprotocol() {
        return this.expectedSubprotocol;
    }

    public String getActualSubprotocol() {
        return this.actualSubprotocol;
    }

    protected void setActualSubprotocol(String actualSubprotocol) {
        this.actualSubprotocol = actualSubprotocol;
    }

    public abstract ChannelFuture handshake(Channel var1);

    public abstract void finishHandshake(Channel var1, HttpResponse var2);
}

