/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.stdio;

import io.netty.bootstrap.ClientBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineFactory;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.MessageEvent;
import io.netty.channel.SimpleChannelHandler;
import io.netty.channel.iostream.IoStreamAddress;
import io.netty.channel.iostream.IoStreamChannelFactory;
import io.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.frame.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.io.PrintStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class StdioLogger {
    private volatile boolean running = true;

    public void run() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        ClientBootstrap bootstrap = new ClientBootstrap(new IoStreamChannelFactory(executorService));
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
                pipeline.addLast("framer", new DelimiterBasedFrameDecoder(8192, Delimiters.lineDelimiter()));
                pipeline.addLast("decoder", new StringDecoder());
                pipeline.addLast("encoder", new StringEncoder());
                pipeline.addLast("loggingHandler", new SimpleChannelHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
                        String message = (String)e.getMessage();
                        PrintStream printStream = System.out;
                        synchronized (printStream) {
                            e.getChannel().write("Message received: " + message);
                        }
                        if ("exit".equals(message)) {
                            StdioLogger.this.running = false;
                        }
                        super.messageReceived(ctx, e);
                    }
                });
                return pipeline;
            }
        });
        ChannelFuture connectFuture = bootstrap.connect(new IoStreamAddress(System.in, System.out));
        Channel channel = connectFuture.awaitUninterruptibly().getChannel();
        while (this.running) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        channel.close().awaitUninterruptibly();
        bootstrap.releaseExternalResources();
    }

    public static void main(String[] args) {
        new StdioLogger().run();
    }
}

