/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.securechat;

import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineFactory;
import io.netty.channel.Channels;
import io.netty.example.securechat.SecureChatClientHandler;
import io.netty.example.securechat.SecureChatSslContextFactory;
import io.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.frame.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;

public class SecureChatClientPipelineFactory
implements ChannelPipelineFactory {
    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        SSLEngine engine = SecureChatSslContextFactory.getClientContext().createSSLEngine();
        pipeline.addLast("ssl", new SslHandler(engine));
        pipeline.addLast("framer", new DelimiterBasedFrameDecoder(8192, Delimiters.lineDelimiter()));
        pipeline.addLast("decoder", new StringDecoder());
        pipeline.addLast("encoder", new StringEncoder());
        pipeline.addLast("handler", new SecureChatClientHandler());
        return pipeline;
    }
}

