/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.websocketx.autobahn;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.socket.nio.NioServerSocketChannelFactory;
import io.netty.example.http.websocketx.autobahn.AutobahnServerPipelineFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

public class AutobahnServer {
    private final int port;

    public AutobahnServer(int port) {
        this.port = port;
    }

    public void run() {
        ServerBootstrap bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(new AutobahnServerPipelineFactory());
        bootstrap.bind(new InetSocketAddress(this.port));
        System.out.println("Web Socket Server started at port " + this.port);
    }

    public static void main(String[] args) {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 9000;
        new AutobahnServer(port).run();
    }
}

