/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.file;

import io.netty.buffer.ChannelBuffers;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelFutureProgressListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.ExceptionEvent;
import io.netty.channel.MessageEvent;
import io.netty.channel.SimpleChannelUpstreamHandler;
import io.netty.handler.codec.frame.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.activation.MimetypesFileTypeMap;

public class HttpStaticFileServerHandler
extends SimpleChannelUpstreamHandler {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final int HTTP_CACHE_SECONDS = 60;

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelFuture writeFuture;
        RandomAccessFile raf;
        long fileLastModifiedSeconds;
        SimpleDateFormat dateFormatter;
        Date ifModifiedSinceDate;
        long ifModifiedSinceDateSeconds;
        HttpRequest request = (HttpRequest)e.getMessage();
        if (request.getMethod() != HttpMethod.GET) {
            this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        final String path = this.sanitizeUri(request.getUri());
        if (path == null) {
            this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        File file = new File(path);
        if (file.isHidden() || !file.exists()) {
            this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        if (!file.isFile()) {
            this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        if (ifModifiedSince != null && !ifModifiedSince.equals("") && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
            this.sendNotModified(ctx);
            return;
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException fnfe) {
            this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        long fileLength = raf.length();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpHeaders.setContentLength(response, fileLength);
        this.setContentTypeHeader(response, file);
        this.setDateAndCacheHeaders(response, file);
        Channel ch = e.getChannel();
        ch.write(response);
        if (ch.getPipeline().get(SslHandler.class) != null) {
            writeFuture = ch.write(new ChunkedFile(raf, 0L, fileLength, 8192));
        } else {
            final DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), 0L, fileLength);
            writeFuture = ch.write(region);
            writeFuture.addListener(new ChannelFutureProgressListener(){

                @Override
                public void operationComplete(ChannelFuture future) {
                    region.releaseExternalResources();
                }

                @Override
                public void operationProgressed(ChannelFuture future, long amount, long current, long total) {
                    System.out.printf("%s: %d / %d (+%d)%n", path, current, total, amount);
                }
            });
        }
        if (!HttpHeaders.isKeepAlive(request)) {
            writeFuture.addListener(ChannelFutureListener.CLOSE);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel ch = e.getChannel();
        Throwable cause = e.getCause();
        if (cause instanceof TooLongFrameException) {
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        cause.printStackTrace();
        if (ch.isConnected()) {
            this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private String sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                throw new Error();
            }
        }
        uri = uri.replace('/', File.separatorChar);
        if (uri.contains(File.separator + ".") || uri.contains("." + File.separator) || uri.startsWith(".") || uri.endsWith(".")) {
            return null;
        }
        return System.getProperty("user.dir") + File.separator + uri;
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setHeader("Content-Type", "text/plain; charset=UTF-8");
        response.setContent(ChannelBuffers.copiedBuffer("Failure: " + status.toString() + "\r\n", CharsetUtil.UTF_8));
        ctx.getChannel().write(response).addListener(ChannelFutureListener.CLOSE);
    }

    private void sendNotModified(ChannelHandlerContext ctx) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        this.setDateHeader(response);
        ctx.getChannel().write(response).addListener(ChannelFutureListener.CLOSE);
    }

    private void setDateHeader(HttpResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.setHeader("Date", dateFormatter.format(time.getTime()));
    }

    private void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.setHeader("Date", dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 60);
        response.setHeader("Expires", dateFormatter.format(time.getTime()));
        response.setHeader("Cache-Control", "private, max-age=60");
        response.setHeader("Last-Modified", dateFormatter.format(new Date(fileToCache.lastModified())));
    }

    private void setContentTypeHeader(HttpResponse response, File file) {
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        response.setHeader("Content-Type", mimeTypesMap.getContentType(file.getPath()));
    }
}

