/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.factorial;

import io.netty.channel.Channel;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelStateEvent;
import io.netty.channel.ExceptionEvent;
import io.netty.channel.MessageEvent;
import io.netty.channel.SimpleChannelUpstreamHandler;
import java.math.BigInteger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FactorialClientHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = Logger.getLogger(FactorialClientHandler.class.getName());
    private int i = 1;
    private int receivedMessages;
    private final int count;
    final BlockingQueue<BigInteger> answer = new LinkedBlockingQueue<BigInteger>();

    public FactorialClientHandler(int count) {
        this.count = count;
    }

    public BigInteger getFactorial() {
        boolean interrupted = false;
        while (true) {
            try {
                BigInteger factorial = this.answer.take();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return factorial;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            logger.info(e.toString());
        }
        super.handleUpstream(ctx, e);
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.sendNumbers(e);
    }

    @Override
    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.sendNumbers(e);
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, final MessageEvent e) {
        ++this.receivedMessages;
        if (this.receivedMessages == this.count) {
            e.getChannel().close().addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) {
                    boolean offered = FactorialClientHandler.this.answer.offer((BigInteger)e.getMessage());
                    assert (offered);
                }
            });
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", e.getCause());
        e.getChannel().close();
    }

    private void sendNumbers(ChannelStateEvent e) {
        Channel channel = e.getChannel();
        while (channel.isWritable() && this.i <= this.count) {
            channel.write(this.i);
            ++this.i;
        }
    }
}

