/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.oio;

import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.Channels;
import io.netty.channel.socket.oio.AbstractOioChannel;
import java.io.IOException;

abstract class AbstractOioWorker<C extends AbstractOioChannel>
implements Runnable {
    protected final C channel;

    public AbstractOioWorker(C channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ((AbstractOioChannel)this.channel).workerThread = Thread.currentThread();
        while (((AbstractChannel)this.channel).isOpen()) {
            Object object = ((AbstractOioChannel)this.channel).interestOpsLock;
            synchronized (object) {
                while (!((AbstractChannel)this.channel).isReadable()) {
                    try {
                        ((AbstractOioChannel)this.channel).interestOpsLock.wait();
                    }
                    catch (InterruptedException e) {
                        if (((AbstractChannel)this.channel).isOpen()) continue;
                        break;
                    }
                }
            }
            try {
                if (this.process()) continue;
                break;
            }
            catch (Throwable t) {
                if (((AbstractOioChannel)this.channel).isSocketClosed()) break;
                Channels.fireExceptionCaught(this.channel, t);
                break;
            }
        }
        ((AbstractOioChannel)this.channel).workerThread = null;
        AbstractOioWorker.close(this.channel, Channels.succeededFuture(this.channel));
    }

    abstract boolean process() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInterestOps(AbstractOioChannel channel, ChannelFuture future, int interestOps) {
        block9: {
            interestOps &= 0xFFFFFFFB;
            interestOps |= channel.getInterestOps() & 4;
            boolean changed = false;
            try {
                if (channel.getInterestOps() != interestOps) {
                    if ((interestOps & 1) != 0) {
                        channel.setInterestOpsNow(1);
                    } else {
                        channel.setInterestOpsNow(0);
                    }
                    changed = true;
                }
                future.setSuccess();
                if (!changed) break block9;
                Object object = channel.interestOpsLock;
                synchronized (object) {
                    channel.setInterestOpsNow(interestOps);
                    Thread currentThread = Thread.currentThread();
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null && currentThread != workerThread) {
                        workerThread.interrupt();
                    }
                }
                Channels.fireChannelInterestChanged(channel);
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
            }
        }
    }

    static void close(AbstractOioChannel channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        try {
            channel.closeSocket();
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    Thread currentThread = Thread.currentThread();
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null && currentThread != workerThread) {
                        workerThread.interrupt();
                    }
                    Channels.fireChannelDisconnected(channel);
                }
                if (bound) {
                    Channels.fireChannelUnbound(channel);
                }
                Channels.fireChannelClosed(channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }
}

