/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp;

import com.sun.nio.sctp.MessageInfo;
import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBuffers;

public final class SctpFrame {
    private final int streamIdentifier;
    private final int protocolIdentifier;
    private final ChannelBuffer payloadBuffer;
    private MessageInfo msgInfo;

    public SctpFrame(int protocolIdentifier, int streamIdentifier, ChannelBuffer payloadBuffer) {
        this.protocolIdentifier = protocolIdentifier;
        this.streamIdentifier = streamIdentifier;
        this.payloadBuffer = payloadBuffer;
    }

    public SctpFrame(MessageInfo msgInfo, ChannelBuffer payloadBuffer) {
        this.msgInfo = msgInfo;
        this.streamIdentifier = msgInfo.streamNumber();
        this.protocolIdentifier = msgInfo.payloadProtocolID();
        this.payloadBuffer = payloadBuffer;
    }

    public int getStreamIdentifier() {
        return this.streamIdentifier;
    }

    public int getProtocolIdentifier() {
        return this.protocolIdentifier;
    }

    public ChannelBuffer getPayloadBuffer() {
        if (this.payloadBuffer.readable()) {
            return this.payloadBuffer.slice();
        }
        return ChannelBuffers.EMPTY_BUFFER;
    }

    public MessageInfo getMessageInfo() {
        return this.msgInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SctpFrame sctpFrame = (SctpFrame)o;
        if (this.protocolIdentifier != sctpFrame.protocolIdentifier) {
            return false;
        }
        if (this.streamIdentifier != sctpFrame.streamIdentifier) {
            return false;
        }
        return ((Object)this.payloadBuffer).equals(sctpFrame.payloadBuffer);
    }

    public int hashCode() {
        int result = this.streamIdentifier;
        result = 31 * result + this.protocolIdentifier;
        result = 31 * result + ((Object)this.payloadBuffer).hashCode();
        return result;
    }

    public String toString() {
        return "SctpFrame{" + "streamIdentifier=" + this.streamIdentifier + ", protocolIdentifier=" + this.protocolIdentifier + ", payloadBuffer=" + ChannelBuffers.hexDump(this.getPayloadBuffer()) + '}';
    }
}

