/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp;

import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.sctp.SctpChannel;
import io.netty.channel.sctp.SctpClientChannel;
import io.netty.channel.sctp.SctpClientPipelineSink;
import io.netty.channel.sctp.SelectorUtil;
import io.netty.util.internal.ExecutorUtil;
import java.util.concurrent.Executor;

public class SctpClientSocketChannelFactory
implements ChannelFactory {
    private final Executor bossExecutor;
    private final Executor workerExecutor;
    private final SctpClientPipelineSink sink;

    public SctpClientSocketChannelFactory(Executor bossExecutor, Executor workerExecutor) {
        this(bossExecutor, workerExecutor, SelectorUtil.DEFAULT_IO_THREADS);
    }

    public SctpClientSocketChannelFactory(Executor bossExecutor, Executor workerExecutor, int workerCount) {
        if (bossExecutor == null) {
            throw new NullPointerException("bossExecutor");
        }
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        if (workerCount <= 0) {
            throw new IllegalArgumentException("workerCount (" + workerCount + ") " + "must be a positive integer.");
        }
        this.bossExecutor = bossExecutor;
        this.workerExecutor = workerExecutor;
        this.sink = new SctpClientPipelineSink(bossExecutor, workerExecutor, workerCount);
    }

    @Override
    public SctpChannel newChannel(ChannelPipeline pipeline) {
        return new SctpClientChannel(this, pipeline, this.sink, this.sink.nextWorker());
    }

    @Override
    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.bossExecutor, this.workerExecutor);
    }
}

