/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelSink;
import io.netty.channel.Channels;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.MessageEvent;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalChannelRegistry;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.internal.QueueFactory;
import io.netty.util.internal.ThreadLocalBoolean;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

final class DefaultLocalChannel
extends AbstractChannel
implements LocalChannel {
    private static final int ST_OPEN = 0;
    private static final int ST_BOUND = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_CLOSED = -1;
    final AtomicInteger state = new AtomicInteger(0);
    private final ChannelConfig config;
    private final ThreadLocalBoolean delivering = new ThreadLocalBoolean();
    final Queue<MessageEvent> writeBuffer = QueueFactory.createQueue(MessageEvent.class);
    volatile DefaultLocalChannel pairedChannel;
    volatile LocalAddress localAddress;
    volatile LocalAddress remoteAddress;

    static DefaultLocalChannel create(LocalServerChannel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, DefaultLocalChannel pairedChannel) {
        DefaultLocalChannel instance = new DefaultLocalChannel(parent, factory, pipeline, sink, pairedChannel);
        Channels.fireChannelOpen(instance);
        return instance;
    }

    private DefaultLocalChannel(LocalServerChannel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, DefaultLocalChannel pairedChannel) {
        super(parent, factory, pipeline, sink);
        this.pairedChannel = pairedChannel;
        this.config = new DefaultChannelConfig();
        this.getCloseFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                DefaultLocalChannel.this.state.set(-1);
            }
        });
    }

    @Override
    public ChannelConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state.get() >= 0;
    }

    @Override
    public boolean isBound() {
        return this.state.get() >= 1;
    }

    @Override
    public boolean isConnected() {
        return this.state.get() == 2;
    }

    void setBound() throws ClosedChannelException {
        if (!this.state.compareAndSet(0, 1)) {
            switch (this.state.get()) {
                case -1: {
                    throw new ClosedChannelException();
                }
            }
            throw new ChannelException("already bound");
        }
    }

    void setConnected() {
        if (this.state.get() != -1) {
            this.state.set(2);
        }
    }

    @Override
    protected boolean setClosed() {
        return super.setClosed();
    }

    @Override
    public LocalAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public LocalAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeNow(ChannelFuture future) {
        LocalAddress localAddress = this.localAddress;
        try {
            if (!this.setClosed()) {
                return;
            }
            DefaultLocalChannel pairedChannel = this.pairedChannel;
            if (pairedChannel != null) {
                this.pairedChannel = null;
                Channels.fireChannelDisconnected(this);
                Channels.fireChannelUnbound(this);
            }
            Channels.fireChannelClosed(this);
            if (pairedChannel == null || !pairedChannel.setClosed()) {
                return;
            }
            DefaultLocalChannel me = pairedChannel.pairedChannel;
            if (me != null) {
                pairedChannel.pairedChannel = null;
                Channels.fireChannelDisconnected(pairedChannel);
                Channels.fireChannelUnbound(pairedChannel);
            }
            Channels.fireChannelClosed(pairedChannel);
        }
        finally {
            future.setSuccess();
            if (localAddress != null && this.getParent() == null) {
                LocalChannelRegistry.unregister(localAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushWriteBuffer() {
        DefaultLocalChannel pairedChannel = this.pairedChannel;
        if (pairedChannel != null) {
            if (pairedChannel.isConnected() && !((Boolean)this.delivering.get()).booleanValue()) {
                this.delivering.set(true);
                try {
                    MessageEvent e;
                    while ((e = this.writeBuffer.poll()) != null) {
                        e.getFuture().setSuccess();
                        Channels.fireMessageReceived(pairedChannel, e.getMessage());
                        Channels.fireWriteComplete(this, 1L);
                    }
                }
                finally {
                    this.delivering.set(false);
                }
            }
        } else {
            MessageEvent e;
            Exception cause = this.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
            while ((e = this.writeBuffer.poll()) != null) {
                e.getFuture().setFailure(cause);
                Channels.fireExceptionCaught(this, (Throwable)cause);
            }
        }
    }
}

