/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.Channels;
import io.netty.channel.ChildChannelStateEvent;

public class DefaultChildChannelStateEvent
implements ChildChannelStateEvent {
    private final Channel parentChannel;
    private final Channel childChannel;

    public DefaultChildChannelStateEvent(Channel parentChannel, Channel childChannel) {
        if (parentChannel == null) {
            throw new NullPointerException("parentChannel");
        }
        if (childChannel == null) {
            throw new NullPointerException("childChannel");
        }
        this.parentChannel = parentChannel;
        this.childChannel = childChannel;
    }

    @Override
    public Channel getChannel() {
        return this.parentChannel;
    }

    @Override
    public ChannelFuture getFuture() {
        return Channels.succeededFuture(this.getChannel());
    }

    @Override
    public Channel getChildChannel() {
        return this.childChannel;
    }

    public String toString() {
        String channelString = this.getChannel().toString();
        StringBuilder buf = new StringBuilder(channelString.length() + 32);
        buf.append(channelString);
        buf.append(this.getChildChannel().isOpen() ? " CHILD_OPEN: " : " CHILD_CLOSED: ");
        buf.append(this.getChildChannel().getId());
        return buf.toString();
    }
}

