/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.util;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.solder.logging.Logger;

public final class NamingUtils {
    private static final Logger log = Logger.getLogger(NamingUtils.class);
    private static Hashtable initialContextProperties;
    private static InitialContext initialContext;

    public static InitialContext getInitialContext(Hashtable<String, String> props) throws NamingException {
        if (props == null) {
            // empty if block
        }
        props = new Hashtable();
        if (log.isDebugEnabled()) {
            log.debug((Object)("JNDI InitialContext properties:" + props));
        }
        try {
            return props.size() == 0 ? new InitialContext() : new InitialContext(props);
        }
        catch (NamingException e) {
            log.debug((Object)"Could not obtain initial context");
            throw e;
        }
    }

    public static InitialContext getInitialContext() throws NamingException {
        if (initialContext == null) {
            NamingUtils.initInitialContext();
        }
        return initialContext;
    }

    private static synchronized void initInitialContext() throws NamingException {
        if (initialContext == null) {
            initialContext = NamingUtils.getInitialContext(initialContextProperties);
        }
    }

    private NamingUtils() {
    }

    public static void setInitialContextProperties(Hashtable initialContextProperties) {
        NamingUtils.initialContextProperties = initialContextProperties;
        initialContext = null;
    }

    public static Hashtable getInitialContextProperties() {
        return initialContextProperties;
    }
}

