/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.hibernate;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jboss.seam.persistence.FlushModeType;
import org.jboss.seam.persistence.HibernatePersistenceProvider;
import org.jboss.seam.persistence.ManagedPersistenceContext;
import org.jboss.seam.persistence.PersistenceContexts;
import org.jboss.seam.persistence.QueryParser;
import org.jboss.seam.persistence.util.BeanManagerUtils;
import org.jboss.seam.persistence.util.InstanceResolver;
import org.jboss.seam.transaction.SeamTransaction;
import org.jboss.seam.transaction.literal.DefaultTransactionLiteral;
import org.jboss.solder.el.Expressions;
import org.jboss.solder.literal.DefaultLiteral;
import org.jboss.solder.logging.Logger;

public class HibernateManagedSessionProxyHandler
implements InvocationHandler,
Serializable,
Synchronization {
    private static final long serialVersionUID = -6539267789786229774L;
    private final Session delegate;
    private PersistenceContexts persistenceContexts;
    private final Set<Annotation> qualifiers;
    protected final BeanManager manager;
    private final HibernatePersistenceProvider provider;
    private boolean persistenceContextsTouched = false;
    private boolean closeOnTransactionCommit = false;
    static final Logger log = Logger.getLogger(HibernateManagedSessionProxyHandler.class);
    private final Instance<Expressions> expressionsInstance;
    private transient SeamTransaction seamTransaction;
    private transient boolean synchronizationRegistered;

    public HibernateManagedSessionProxyHandler(Session delegate, BeanManager beanManager, Set<Annotation> qualifiers, HibernatePersistenceProvider provider, BeanManager manager) {
        this.qualifiers = qualifiers;
        this.provider = provider;
        this.delegate = delegate;
        this.expressionsInstance = InstanceResolver.getInstance(Expressions.class, beanManager);
        this.manager = manager;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.touch((ManagedPersistenceContext)proxy);
        if ("changeFlushMode".equals(method.getName()) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(FlushModeType.class)) {
            this.changeFushMode((FlushModeType)args[0]);
            return null;
        }
        if ("getBeanType".equals(method.getName()) && method.getParameterTypes().length == 0) {
            return EntityManager.class;
        }
        if ("getQualifiers".equals(method.getName()) && method.getParameterTypes().length == 0) {
            return Collections.unmodifiableSet(this.qualifiers);
        }
        if ("getProvider".equals(method.getName()) && method.getParameterTypes().length == 0) {
            return this.provider;
        }
        if ("closeAfterTransaction".equals(method.getName()) && method.getParameterTypes().length == 0) {
            this.closeAfterTransaction();
            return null;
        }
        if ("createQuery".equals(method.getName()) && method.getParameterTypes().length > 0 && method.getParameterTypes()[0].equals(String.class)) {
            return this.handleCreateQueryWithString(method, args);
        }
        if (!("setFlushMode".equals(method.getName()) || "getTransaction".equals(method.getName()) || this.synchronizationRegistered)) {
            this.joinTransaction();
        }
        return method.invoke((Object)this.delegate, args);
    }

    protected Object handleCreateQueryWithString(Method method, Object[] args) throws Throwable {
        if (args[0] == null) {
            return method.invoke((Object)this.delegate, args);
        }
        String ejbql = (String)args[0];
        if (ejbql.indexOf(35) > 0) {
            QueryParser qp = new QueryParser((Expressions)this.expressionsInstance.get(), ejbql);
            Object[] newArgs = (Object[])args.clone();
            newArgs[0] = qp.getEjbql();
            Query query = (Query)method.invoke((Object)this.delegate, newArgs);
            for (int i = 0; i < qp.getParameterValues().size(); ++i) {
                query.setParameter(QueryParser.getParameterName(i), qp.getParameterValues().get(i));
            }
            return query;
        }
        return method.invoke((Object)this.delegate, args);
    }

    private void joinTransaction() throws SystemException {
        SeamTransaction transaction = this.getTransaction();
        if (transaction.isActive()) {
            this.delegate.isOpen();
            try {
                transaction.registerSynchronization((Synchronization)this);
                this.synchronizationRegistered = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void closeAfterTransaction() throws SystemException {
        SeamTransaction transaction = this.getTransaction();
        if (transaction.isActive()) {
            this.closeOnTransactionCommit = true;
        } else if (this.delegate.isOpen()) {
            this.delegate.close();
        }
    }

    private void changeFushMode(FlushModeType flushModeType) {
        switch (flushModeType) {
            case AUTO: {
                this.delegate.setFlushMode(FlushMode.AUTO);
                break;
            }
            case MANUAL: {
                this.delegate.setFlushMode(FlushMode.MANUAL);
                break;
            }
            case COMMIT: {
                this.delegate.setFlushMode(FlushMode.COMMIT);
                break;
            }
            default: {
                throw new RuntimeException("Unkown flush mode: " + flushModeType);
            }
        }
    }

    void touch(ManagedPersistenceContext delegate) {
        if (!this.persistenceContextsTouched) {
            try {
                this.persistenceContextsTouched = true;
                this.getPersistenceContexts().touch(delegate);
            }
            catch (ContextNotActiveException e) {
                this.persistenceContextsTouched = false;
                log.debug((Object)("Not touching pc " + this + "as conversation scope not active"));
            }
        }
    }

    public void afterCompletion(int status) {
        this.synchronizationRegistered = false;
        if (this.closeOnTransactionCommit && this.delegate.isOpen()) {
            this.delegate.close();
        }
    }

    public void beforeCompletion() {
    }

    private PersistenceContexts getPersistenceContexts() {
        if (this.persistenceContexts == null) {
            Bean bean = this.manager.resolve(this.manager.getBeans(PersistenceContexts.class, new Annotation[]{DefaultLiteral.INSTANCE}));
            if (bean == null) {
                throw new RuntimeException("Could not find PersistenceContexts bean");
            }
            CreationalContext ctx = this.manager.createCreationalContext((Contextual)bean);
            this.persistenceContexts = (PersistenceContexts)this.manager.getReference(bean, PersistenceContexts.class, ctx);
        }
        return this.persistenceContexts;
    }

    private SeamTransaction getTransaction() {
        if (this.seamTransaction == null) {
            this.seamTransaction = BeanManagerUtils.getContextualInstance(this.manager, SeamTransaction.class, new Annotation[]{DefaultTransactionLiteral.INSTANCE});
        }
        return this.seamTransaction;
    }
}

