/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Inject;
import org.jboss.solder.beanManager.BeanManagerAware;
import org.jboss.solder.logging.Logger;
import org.jboss.solder.reflection.Reflections;
import org.jboss.solder.reflection.annotated.AnnotatedTypeBuilder;

public class InjectionEventListener
extends BeanManagerAware {
    private static final Logger log = Logger.getLogger(InjectionEventListener.class);
    private final Map<Class<?>, InjectionTarget<?>> injectionTargets = new ConcurrentHashMap();
    private static final InjectionTarget NULL_INJECTION_TARGET = new InjectionTarget(){

        public void inject(Object instance, CreationalContext ctx) {
        }

        public void postConstruct(Object instance) {
        }

        public void preDestroy(Object instance) {
        }

        public void dispose(Object instance) {
        }

        public Set getInjectionPoints() {
            return null;
        }

        public Object produce(CreationalContext ctx) {
            return null;
        }
    };

    public void load(Object entity) {
        InjectionTarget<?> it;
        if (!this.injectionTargets.containsKey(entity.getClass())) {
            if (!this.injectionRequired(entity.getClass())) {
                this.injectionTargets.put(entity.getClass(), NULL_INJECTION_TARGET);
                log.debugv("Entity {} has no injection points so injection will not be enabled", entity.getClass());
            } else {
                AnnotatedTypeBuilder builder = new AnnotatedTypeBuilder().readFromType(entity.getClass());
                InjectionTarget injectionTarget = this.getBeanManager().createInjectionTarget(builder.create());
                this.injectionTargets.put(entity.getClass(), injectionTarget);
                log.infov("Enabling injection into entity {}", entity.getClass());
            }
        }
        if ((it = this.injectionTargets.get(entity.getClass())) != NULL_INJECTION_TARGET) {
            log.debugv("Running CDI injection for {}", entity.getClass());
            it.inject(entity, (CreationalContext)new CreationalContextImpl());
        }
    }

    private boolean injectionRequired(Class<?> entityClass) {
        for (Field f : Reflections.getAllDeclaredFields(entityClass)) {
            if (!f.isAnnotationPresent(Inject.class)) continue;
            return true;
        }
        for (Method m : Reflections.getAllDeclaredMethods(entityClass)) {
            if (!m.isAnnotationPresent(Inject.class)) continue;
            return true;
        }
        for (Constructor c : Reflections.getAllDeclaredConstructors(entityClass)) {
            if (!c.isAnnotationPresent(Inject.class)) continue;
            return true;
        }
        return false;
    }

    private static class CreationalContextImpl
    implements CreationalContext {
        private CreationalContextImpl() {
        }

        public void push(Object incompleteInstance) {
        }

        public void release() {
        }
    }
}

