/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.uptime;

import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.example.uptime.UptimeClientHandler;
import org.jboss.netty.handler.timeout.ReadTimeoutHandler;
import org.jboss.netty.util.HashedWheelTimer;

public class UptimeClient {
    static final int RECONNECT_DELAY = 5;
    private static final int READ_TIMEOUT = 10;

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: " + UptimeClient.class.getSimpleName() + " <host> <port>");
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        final HashedWheelTimer timer = new HashedWheelTimer();
        final ClientBootstrap bootstrap = new ClientBootstrap(new NioClientSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline(new ReadTimeoutHandler(timer, 10), new UptimeClientHandler(bootstrap, timer));
            }
        });
        bootstrap.setOption("remoteAddress", new InetSocketAddress(host, port));
        bootstrap.connect();
    }
}

