/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.localtime;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.example.localtime.LocalTimeClientHandler;
import org.jboss.netty.example.localtime.LocalTimeClientPipelineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTimeClient {
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            LocalTimeClient.printUsage();
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        List<String> cities = LocalTimeClient.parseCities(args, 2);
        if (cities == null) {
            return;
        }
        ClientBootstrap bootstrap = new ClientBootstrap(new NioClientSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(new LocalTimeClientPipelineFactory());
        ChannelFuture connectFuture = bootstrap.connect(new InetSocketAddress(host, port));
        Channel channel = connectFuture.awaitUninterruptibly().getChannel();
        LocalTimeClientHandler handler = channel.getPipeline().get(LocalTimeClientHandler.class);
        List<String> response = handler.getLocalTimes(cities);
        channel.close().awaitUninterruptibly();
        bootstrap.releaseExternalResources();
        Iterator i1 = cities.iterator();
        Iterator<String> i2 = response.iterator();
        while (i1.hasNext()) {
            System.out.format("%28s: %s%n", i1.next(), i2.next());
        }
    }

    private static void printUsage() {
        System.err.println("Usage: " + LocalTimeClient.class.getSimpleName() + " <host> <port> <continent/city_name> ...");
        System.err.println("Example: " + LocalTimeClient.class.getSimpleName() + " localhost 8080 America/New_York Asia/Seoul");
    }

    private static List<String> parseCities(String[] args, int offset) {
        ArrayList<String> cities = new ArrayList<String>();
        for (int i = offset; i < args.length; ++i) {
            if (!args[i].matches("^[_A-Za-z]+/[_A-Za-z]+$")) {
                System.err.println("Syntax error: '" + args[i] + "'");
                LocalTimeClient.printUsage();
                return null;
            }
            cities.add(args[i].trim());
        }
        return cities;
    }
}

