/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.mime.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaTypeRegistry {
    private final Map<MediaType, MediaType> registry = new HashMap<MediaType, MediaType>();
    private final Map<MediaType, MediaType> inheritance = new HashMap<MediaType, MediaType>();

    public static MediaTypeRegistry getDefaultRegistry() {
        return TikaConfig.getDefaultConfig().getMediaTypeRegistry();
    }

    public SortedSet<MediaType> getTypes() {
        return new TreeSet<MediaType>(this.registry.values());
    }

    public SortedSet<MediaType> getAliases(MediaType type) {
        TreeSet<MediaType> aliases = new TreeSet<MediaType>();
        for (Map.Entry<MediaType, MediaType> entry : this.registry.entrySet()) {
            if (!entry.getValue().equals(type) || entry.getKey().equals(type)) continue;
            aliases.add(entry.getKey());
        }
        return aliases;
    }

    public void addType(MediaType type) {
        this.registry.put(type, type);
    }

    public void addAlias(MediaType type, MediaType alias) {
        this.registry.put(alias, type);
    }

    public void addSuperType(MediaType type, MediaType supertype) {
        this.inheritance.put(type, supertype);
    }

    public MediaType normalize(MediaType type) {
        MediaType canonical = this.registry.get(type.getBaseType());
        if (canonical == null) {
            return type;
        }
        if (type.hasParameters()) {
            return new MediaType(canonical, type.getParameters());
        }
        return canonical;
    }

    public boolean isSpecializationOf(MediaType a, MediaType b) {
        MediaType x = this.getSupertype(a);
        return x != null && (x.equals(b) || this.isSpecializationOf(x, b));
    }

    public MediaType getSupertype(MediaType type) {
        if (type.hasParameters()) {
            return type.getBaseType();
        }
        if (this.inheritance.containsKey(type)) {
            return this.inheritance.get(type);
        }
        if (type.getSubtype().endsWith("+xml")) {
            return MediaType.APPLICATION_XML;
        }
        if (type.getSubtype().endsWith("+zip")) {
            return MediaType.APPLICATION_ZIP;
        }
        if ("text".equals(type.getType()) && !MediaType.TEXT_PLAIN.equals(type)) {
            return MediaType.TEXT_PLAIN;
        }
        if (!MediaType.OCTET_STREAM.equals(type)) {
            return MediaType.OCTET_STREAM;
        }
        return null;
    }
}

