/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.integrationtests;

import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.ModelToGraphConverter;
import org.drools.impact.analysis.graph.ReactivityType;
import org.drools.impact.analysis.integrationtests.AbstractGraphTest;
import org.drools.impact.analysis.integrationtests.domain.Address;
import org.drools.impact.analysis.integrationtests.domain.Person;
import org.drools.impact.analysis.model.AnalysisModel;
import org.drools.impact.analysis.parser.ModelBuilder;
import org.junit.Test;

public class PropertyTest
extends AbstractGraphTest {
    @Test
    public void testNestedProperty() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\n  $p : Person()\nthen\n  modify ($p) {getAddress().setNumber(10)};end\nrule R2 when\n  $p : Person(address.number == 10)\nthen\nend\n";
        this.runRule(str, new Object[]{new Person("John", 20, new Address())});
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.UNKNOWN);
        this.generatePng(graph);
    }

    @Test
    public void testPropertyInFunction() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\n  $p : Person()\nthen\n  modify ($p) {setAge(42)};end\nrule R2 when\n  $p : Person(calculateToMonth(age) > 480)\nthen\nend\n";
        this.runRule(str, new Object[]{new Person("John")});
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.UNKNOWN);
        this.generatePng(graph);
    }

    @Test
    public void testUnaryBoolean() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";\nrule R1 when\n  $p : Person(age >= 20)\nthen\n  modify ($p) {setEmployed(true)};\nend\nrule R2 when\n  $p : Person(age < 20)\nthen\n  modify ($p) {setEmployed(false)};\nend\nrule R3 when\n  $p : Person(employed)\nthen\nend\nrule R4 when\n  $p : Person(!employed)\nthen\nend\n";
        Person person = new Person("John", 30);
        person.setEmployed(false);
        this.runRule(str, new Object[]{person});
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R4", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R2", "mypkg.R3", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R2", "mypkg.R4", ReactivityType.POSITIVE);
        this.generatePng(graph);
    }
}

