/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.container.integration.tests;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.command.runtime.process.GetProcessIdsCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.camel.container.integration.tests.AbstractKieCamelIntegrationTest;

public class ProcessEngineIntegrationTest
extends AbstractKieCamelIntegrationTest {
    private static final String SIMPLE_PROCESS_ID = "process1";
    private static final String PROCESS_WITH_SIGNAL = "processWithSignal";
    private static final String SIGNAL_NAME = "signal1";

    @Test
    public void testGetProcessIds() {
        GetProcessIdsCommand getProcessIdsCommand = new GetProcessIdsCommand();
        getProcessIdsCommand.setOutIdentifier("out-identifier");
        ExecutionResults executionResults = this.runCommand((Command)getProcessIdsCommand);
        Assertions.assertThat((Object)executionResults).isNotNull();
        Assertions.assertThat((List)((List)executionResults.getValue("out-identifier"))).contains(new Object[]{SIMPLE_PROCESS_ID, PROCESS_WITH_SIGNAL});
    }

    @Test
    public void testStartProcess() {
        StartProcessCommand command = (StartProcessCommand)this.kieCommands.newStartProcess(SIMPLE_PROCESS_ID);
        command.setOutIdentifier("out-identifier");
        ExecutionResults response = this.runCommand((Command)command);
        Assertions.assertThat((Object)response).isNotNull();
        Long processId = (Long)response.getValue("out-identifier");
        Assertions.assertThat((Long)processId).isNotNull();
        Assertions.assertThat((Long)processId).isPositive();
    }

    @Test
    public void testSignalToProcess() {
        StartProcessCommand startProcessCommand = (StartProcessCommand)this.kieCommands.newStartProcess(PROCESS_WITH_SIGNAL);
        startProcessCommand.setOutIdentifier("out-identifier");
        ExecutionResults responseStartProcess = this.runCommand((Command)startProcessCommand);
        Assertions.assertThat((Object)responseStartProcess).isNotNull();
        Long processId = (Long)responseStartProcess.getValue("out-identifier");
        Assertions.assertThat((Long)processId).isNotNull();
        Assertions.assertThat((Long)processId).isPositive();
        Assertions.assertThat(this.listProcesses()).contains((Object[])new Long[]{processId});
        SignalEventCommand signalEventCommand = new SignalEventCommand(SIGNAL_NAME, new Object());
        this.runCommand((Command)signalEventCommand);
        Assertions.assertThat(this.listProcesses()).doesNotContain((Object[])new Long[]{processId});
    }
}

