/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.commons.data.file;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import org.drombler.commons.context.ContextInjector;
import org.drombler.commons.context.ContextManager;
import org.drombler.commons.context.Contexts;
import org.drombler.commons.data.DataHandler;
import org.drombler.commons.data.DataHandlerRegistry;
import org.drombler.commons.data.Openable;
import org.drombler.commons.data.file.DocumentHandlerDescriptor;
import org.drombler.commons.data.file.DocumentHandlerDescriptorRegistry;
import org.drombler.commons.data.file.FileExtensionDescriptor;
import org.drombler.commons.data.file.FileExtensionDescriptorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.softsmithy.lib.nio.file.PathUtils;
import org.softsmithy.lib.util.CloseEvent;
import org.softsmithy.lib.util.CloseEventListener;

public class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);

    public static void openFile(Path fileToOpen, DataHandlerRegistry dataHandlerRegistry, FileExtensionDescriptorRegistry fileExtensionDescriptorRegistry, DocumentHandlerDescriptorRegistry documentHandlerDescriptorRegistry, ContextManager contextManager, ContextInjector contextInjector) {
        LOG.debug("Start opening file {}...", (Object)fileToOpen);
        Object documentHandler = FileUtils.getDocumentHandler(fileToOpen, dataHandlerRegistry, fileExtensionDescriptorRegistry, documentHandlerDescriptorRegistry, contextManager, contextInjector);
        if (documentHandler != null && (!(documentHandler instanceof DataHandler) || ((DataHandler)documentHandler).isInitialized())) {
            FileUtils.openDocument(documentHandler);
        }
    }

    private static Object getDocumentHandler(Path fileToOpen, DataHandlerRegistry dataHandlerRegistry, FileExtensionDescriptorRegistry fileExtensionDescriptorRegistry, DocumentHandlerDescriptorRegistry documentHandlerDescriptorRegistry, ContextManager contextManager, ContextInjector contextInjector) {
        DocumentHandlerDescriptor<?> documentHandlerDescriptor = FileUtils.getDocumentHandlerDescriptor(fileToOpen, fileExtensionDescriptorRegistry, documentHandlerDescriptorRegistry);
        if (documentHandlerDescriptor != null) {
            if (FileUtils.registeredDataHandlerForUniqueKeyExists(documentHandlerDescriptor, dataHandlerRegistry, fileToOpen)) {
                return dataHandlerRegistry.getDataHandler(documentHandlerDescriptor.getDataHandlerClass(), fileToOpen);
            }
            Object documentHandler = FileUtils.createNewDocumentHandler(documentHandlerDescriptor, fileToOpen);
            if (documentHandler != null && documentHandler instanceof DataHandler) {
                FileUtils.configureDataHandler((DataHandler)documentHandler, contextManager, contextInjector, dataHandlerRegistry);
            }
            return documentHandler;
        }
        return null;
    }

    private static boolean registeredDataHandlerForUniqueKeyExists(DocumentHandlerDescriptor<?> documentHandlerDescriptor, DataHandlerRegistry dataHandlerRegistry, Path fileToOpen) {
        return DataHandler.class.isAssignableFrom(documentHandlerDescriptor.getDataHandlerClass()) && dataHandlerRegistry.containsDataHandlerForUniqueKey(documentHandlerDescriptor.getDataHandlerClass(), fileToOpen);
    }

    private static void configureDataHandler(final DataHandler<?> dataHandler, final ContextManager contextManager, ContextInjector contextInjector, final DataHandlerRegistry dataHandlerRegistry) {
        Contexts.configureObject(dataHandler, (ContextManager)contextManager, (ContextInjector)contextInjector);
        if (dataHandler.isInitialized()) {
            dataHandlerRegistry.registerDataHandler(dataHandler);
        } else {
            dataHandler.addPropertyChangeListener("initialized", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (dataHandler.isInitialized()) {
                        dataHandlerRegistry.registerDataHandler(dataHandler);
                        FileUtils.openDocument(dataHandler);
                        dataHandler.removePropertyChangeListener("initialized", this);
                    }
                }
            });
        }
        dataHandler.addCloseEventListener(new CloseEventListener(){

            public void onClose(CloseEvent evt) {
                dataHandler.removeCloseEventListener(this);
                dataHandlerRegistry.unregisterDataHandler(dataHandler);
                contextManager.unregisterLocalContext((Object)dataHandler);
            }
        });
    }

    private static Object createNewDocumentHandler(DocumentHandlerDescriptor<?> documentHandlerDescriptor, Path fileToOpen) {
        try {
            return documentHandlerDescriptor.createDocumentHandler(fileToOpen);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            LOG.error("Could not create a document handler for " + fileToOpen + "!", (Throwable)ex);
            return null;
        }
    }

    private static DocumentHandlerDescriptor<?> getDocumentHandlerDescriptor(Path fileToOpen, FileExtensionDescriptorRegistry fileExtensionDescriptorRegistry, DocumentHandlerDescriptorRegistry documentHandlerDescriptorRegistry) {
        String extension = PathUtils.getExtension((Path)fileToOpen);
        FileExtensionDescriptor fileExtensionDescriptor = fileExtensionDescriptorRegistry.getFileExtensionDescriptor(extension);
        if (fileExtensionDescriptor != null) {
            String mimeType = fileExtensionDescriptor.getMimeType();
            DocumentHandlerDescriptor<?> documentHandlerDescriptor = documentHandlerDescriptorRegistry.getDocumentHandlerDescriptor(mimeType);
            if (documentHandlerDescriptor != null) {
                LOG.warn("No DocumentHandlerDescriptor found for:" + mimeType + "!");
            }
            return documentHandlerDescriptor;
        }
        LOG.warn("No FileExtensionDescriptor found for:" + extension + "!");
        return null;
    }

    private static void openDocument(Object documentHandler) {
        Openable openable = (Openable)Contexts.find((Object)documentHandler, Openable.class);
        if (openable != null) {
            openable.open();
        } else {
            LOG.warn("No Openable found for " + documentHandler + "! The document handler either does not implement LocalContextProvider or does not observe registered DataCapabilityProvider.");
        }
    }
}

