/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.commons.data.file;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drombler.commons.data.file.FileExtensionDescriptor;
import org.softsmithy.lib.util.SetChangeEvent;
import org.softsmithy.lib.util.SetChangeListener;

public class FileExtensionDescriptorRegistry {
    private final Map<String, FileExtensionDescriptor> fileExtensions = new HashMap<String, FileExtensionDescriptor>();
    private final Set<FileExtensionDescriptor> fileExtensionDescriptors = new HashSet<FileExtensionDescriptor>();
    private final Set<FileExtensionDescriptor> unmodifiableFileExtensionDescriptors = Collections.unmodifiableSet(this.fileExtensionDescriptors);
    private final Set<SetChangeListener<FileExtensionDescriptor>> listeners = new HashSet<SetChangeListener<FileExtensionDescriptor>>();

    public void registerFileExtensionDescriptor(FileExtensionDescriptor fileExtensionDescriptor) {
        fileExtensionDescriptor.getFileExtensions().stream().map(String::toLowerCase).forEach(fileExtension -> this.fileExtensions.put((String)fileExtension, fileExtensionDescriptor));
        this.fileExtensionDescriptors.add(fileExtensionDescriptor);
        this.fireFileExtensionAdded(fileExtensionDescriptor);
    }

    public void unregisterFileExtensionDescriptor(FileExtensionDescriptor fileExtensionDescriptor) {
        fileExtensionDescriptor.getFileExtensions().stream().map(String::toLowerCase).forEach(this.fileExtensions::remove);
        this.fileExtensionDescriptors.remove(fileExtensionDescriptor);
        this.fireFileExtensionRemoved(fileExtensionDescriptor);
    }

    public FileExtensionDescriptor getFileExtensionDescriptor(String fileExtension) {
        return this.fileExtensions.get(fileExtension.toLowerCase());
    }

    public void addFileExtensionListener(SetChangeListener<FileExtensionDescriptor> listener) {
        this.listeners.add(listener);
    }

    public void removeFileExtensionListener(SetChangeListener<FileExtensionDescriptor> listener) {
        this.listeners.remove(listener);
    }

    public Set<FileExtensionDescriptor> getAllFileExtensionDescriptors() {
        return this.unmodifiableFileExtensionDescriptors;
    }

    private void fireFileExtensionAdded(FileExtensionDescriptor fileExtensionDescriptor) {
        SetChangeEvent event = new SetChangeEvent(this.unmodifiableFileExtensionDescriptors, (Object)fileExtensionDescriptor);
        this.listeners.forEach(listener -> listener.elementAdded(event));
    }

    private void fireFileExtensionRemoved(FileExtensionDescriptor fileExtensionDescriptor) {
        SetChangeEvent event = new SetChangeEvent(this.unmodifiableFileExtensionDescriptors, (Object)fileExtensionDescriptor);
        this.listeners.forEach(listener -> listener.elementRemoved(event));
    }
}

