/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.commons.data.file;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drombler.commons.data.file.DocumentHandlerDescriptor;
import org.softsmithy.lib.util.SetChangeEvent;
import org.softsmithy.lib.util.SetChangeListener;

public class DocumentHandlerDescriptorRegistry {
    private final Map<String, DocumentHandlerDescriptor<?>> mimeTypes = new HashMap();
    private final Set<DocumentHandlerDescriptor<?>> documentHandlerDescriptors = new HashSet();
    private final Set<DocumentHandlerDescriptor<?>> unmodifiableDocumentHandlerDescriptors = Collections.unmodifiableSet(this.documentHandlerDescriptors);
    private final Set<SetChangeListener<DocumentHandlerDescriptor<?>>> listeners = new HashSet();

    public void registerDocumentHandlerDescriptor(DocumentHandlerDescriptor<?> documentHandlerDescriptor) {
        this.mimeTypes.put(documentHandlerDescriptor.getMimeType().toLowerCase(), documentHandlerDescriptor);
        this.documentHandlerDescriptors.add(documentHandlerDescriptor);
        this.fireDocumentHandlerAdded(documentHandlerDescriptor);
    }

    public void unregisterDocumentHandlerDescriptor(DocumentHandlerDescriptor<?> documentHandlerDescriptor) {
        this.mimeTypes.remove(documentHandlerDescriptor.getMimeType().toLowerCase(), documentHandlerDescriptor);
        this.documentHandlerDescriptors.remove(documentHandlerDescriptor);
        this.fireDocumentHandlerRemoved(documentHandlerDescriptor);
    }

    public DocumentHandlerDescriptor<?> getDocumentHandlerDescriptor(String mimeType) {
        return this.mimeTypes.get(mimeType.toLowerCase());
    }

    public void addDocumentHandlerDescriptorListener(SetChangeListener<DocumentHandlerDescriptor<?>> listener) {
        this.listeners.add(listener);
    }

    public void removeDocumentHandlerDescriptorListener(SetChangeListener<DocumentHandlerDescriptor<?>> listener) {
        this.listeners.remove(listener);
    }

    private void fireDocumentHandlerAdded(DocumentHandlerDescriptor<?> documentHandlerDescriptor) {
        SetChangeEvent event = new SetChangeEvent(this.unmodifiableDocumentHandlerDescriptors, documentHandlerDescriptor);
        this.listeners.forEach(listener -> listener.elementAdded(event));
    }

    private <D> void fireDocumentHandlerRemoved(DocumentHandlerDescriptor<D> documentHandlerDescriptor) {
        SetChangeEvent event = new SetChangeEvent(this.unmodifiableDocumentHandlerDescriptors, documentHandlerDescriptor);
        this.listeners.forEach(listener -> listener.elementRemoved(event));
    }
}

