/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.commons.data;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.drombler.commons.data.DataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.softsmithy.lib.util.UniqueKeyProvider;

public class DataHandlerRegistry
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DataHandlerRegistry.class);
    private final Map<DataHandlerRegistryKey<?, ?>, DataHandler<?>> dataHandlers = new HashMap();

    public <K, D extends DataHandler<K>> D registerDataHandler(final D dataHandler) {
        final DataHandlerRegistryKey<K, D> dataHandlerRegistryKey = this.createDataHandlerRegistryKey(dataHandler);
        if (dataHandler.getUniqueKey() != null) {
            if (!this.containsDataHandlerForUniqueKey(dataHandlerRegistryKey)) {
                this.dataHandlers.put(dataHandlerRegistryKey, dataHandler);
                return dataHandler;
            }
            return this.getDataHandler(dataHandlerRegistryKey);
        }
        PropertyChangeListener uniqueKeyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (dataHandler.getUniqueKey() != null) {
                    if (!DataHandlerRegistry.this.containsDataHandlerForUniqueKey(dataHandlerRegistryKey)) {
                        DataHandlerRegistry.this.dataHandlers.put(dataHandlerRegistryKey, dataHandler);
                    }
                    dataHandler.removePropertyChangeListener("uniqueKey", this);
                }
            }
        };
        dataHandler.addPropertyChangeListener("uniqueKey", uniqueKeyListener);
        return dataHandler;
    }

    private <K, D extends DataHandler<K>> DataHandlerRegistryKey<K, D> createDataHandlerRegistryKey(D dataHandler) {
        return new DataHandlerRegistryKey(dataHandler.getClass(), dataHandler.getUniqueKey());
    }

    public void unregisterDataHandler(DataHandler<?> dataHandler) {
        DataHandlerRegistryKey dataHandlerRegistryKey = this.createDataHandlerRegistryKey(dataHandler);
        this.dataHandlers.remove(dataHandlerRegistryKey);
        this.closeDataHandler(dataHandler);
    }

    public <K, D extends DataHandler<K>> boolean containsDataHandlerForUniqueKey(Class<D> type, K uniqueKey) {
        DataHandlerRegistryKey<K, D> dataHandlerRegistryKey = new DataHandlerRegistryKey<K, D>(type, uniqueKey);
        return this.containsDataHandlerForUniqueKey(dataHandlerRegistryKey);
    }

    private <K, D extends DataHandler<K>> boolean containsDataHandlerForUniqueKey(DataHandlerRegistryKey<K, D> dataHandlerRegistryKey) {
        return this.dataHandlers.containsKey(dataHandlerRegistryKey);
    }

    public <K, D extends DataHandler<K>> D getDataHandler(Class<D> type, K uniqueKey) {
        DataHandlerRegistryKey<K, D> dataHandlerRegistryKey = new DataHandlerRegistryKey<K, D>(type, uniqueKey);
        return this.getDataHandler(dataHandlerRegistryKey);
    }

    private <K, D extends DataHandler<K>> D getDataHandler(DataHandlerRegistryKey<K, D> dataHandlerRegistryKey) {
        return (D)((DataHandler)dataHandlerRegistryKey.getType().cast(this.dataHandlers.get(dataHandlerRegistryKey)));
    }

    @Override
    public void close() {
        HashMap dataHandlersCopy = new HashMap(this.dataHandlers);
        dataHandlersCopy.entrySet().stream().map(Map.Entry::getValue).forEach(this::closeDataHandler);
        this.dataHandlers.clear();
    }

    private void closeDataHandler(UniqueKeyProvider<?> dataHandler) {
        if (dataHandler instanceof AutoCloseable) {
            AutoCloseable autoCloseable = (AutoCloseable)dataHandler;
            try {
                autoCloseable.close();
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private static class DataHandlerRegistryKey<K, D extends DataHandler<K>> {
        private final Class<D> type;
        private final K uniqueKey;

        public DataHandlerRegistryKey(Class<D> type, K uniqueKey) {
            this.type = type;
            this.uniqueKey = uniqueKey;
        }

        public Class<D> getType() {
            return this.type;
        }

        public K getUniqueKey() {
            return this.uniqueKey;
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + Objects.hashCode(this.type);
            hash = 53 * hash + Objects.hashCode(this.uniqueKey);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataHandlerRegistryKey)) {
                return false;
            }
            DataHandlerRegistryKey other = (DataHandlerRegistryKey)obj;
            return Objects.equals(this.type, other.type) && Objects.equals(this.uniqueKey, other.uniqueKey);
        }
    }
}

