/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.commons.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drombler.commons.data.AbstractDataHandlerDescriptor;
import org.softsmithy.lib.util.SetChangeEvent;
import org.softsmithy.lib.util.SetChangeListener;

public class DataHandlerDescriptorRegistry {
    private final Map<Class<?>, AbstractDataHandlerDescriptor<?>> dataHandlerClasses = new HashMap();
    private final Set<AbstractDataHandlerDescriptor<?>> dataHandlerDescriptors = new HashSet();
    private final Set<AbstractDataHandlerDescriptor<?>> unmodifiableDataHandlerDescriptors = Collections.unmodifiableSet(this.dataHandlerDescriptors);
    private final Set<SetChangeListener<AbstractDataHandlerDescriptor<?>>> listeners = new HashSet();

    public void registerDataHandlerDescriptor(AbstractDataHandlerDescriptor<?> dataHandlerDescriptor) {
        this.dataHandlerClasses.put(dataHandlerDescriptor.getDataHandlerClass(), dataHandlerDescriptor);
        this.dataHandlerDescriptors.add(dataHandlerDescriptor);
        this.fireDataHandlerDescriptorAdded(dataHandlerDescriptor);
    }

    public void unregisterDataHandlerDescriptor(AbstractDataHandlerDescriptor<?> dataHandlerDescriptor) {
        this.dataHandlerClasses.remove(dataHandlerDescriptor.getDataHandlerClass(), dataHandlerDescriptor);
        this.dataHandlerDescriptors.remove(dataHandlerDescriptor);
        this.fireDataHandlerDescriptorRemoved(dataHandlerDescriptor);
    }

    public AbstractDataHandlerDescriptor<?> getDataHandlerDescriptor(Object dataHandler) {
        return this.dataHandlerClasses.get(dataHandler.getClass());
    }

    public void addDataHandlerDescriptorListener(SetChangeListener<AbstractDataHandlerDescriptor<?>> listener) {
        this.listeners.add(listener);
    }

    public void removeDataHandlerDescriptorListener(SetChangeListener<AbstractDataHandlerDescriptor<?>> listener) {
        this.listeners.remove(listener);
    }

    private void fireDataHandlerDescriptorAdded(AbstractDataHandlerDescriptor<?> dataHandlerDescriptor) {
        SetChangeEvent event = new SetChangeEvent(this.unmodifiableDataHandlerDescriptors, dataHandlerDescriptor);
        this.listeners.forEach(listener -> listener.elementAdded(event));
    }

    private <D> void fireDataHandlerDescriptorRemoved(AbstractDataHandlerDescriptor<D> dataHandlerDescriptor) {
        SetChangeEvent event = new SetChangeEvent(this.unmodifiableDataHandlerDescriptors, dataHandlerDescriptor);
        this.listeners.forEach(listener -> listener.elementRemoved(event));
    }
}

