/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.startup.main.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.felix.framework.util.Util;
import org.drombler.acp.startup.main.ApplicationConfigProvider;
import org.drombler.acp.startup.main.impl.ApplicationConfigProviderImpl;
import org.drombler.acp.startup.main.impl.AutoProcessor;
import org.drombler.acp.startup.main.impl.CommandLineArgs;
import org.drombler.acp.startup.main.impl.MissingPropertyException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class Main {
    public static final String USER_DIR_PROPERTY = "platform.userdir";
    public static final String SHUTDOWN_HOOK_PROP = "felix.shutdown.hook";
    public static final String SYSTEM_PROPERTIES_PROP = "felix.system.properties";
    public static final String SYSTEM_PROPERTIES_FILE_VALUE = "system.properties";
    public static final String CONFIG_PROPERTIES_PROP = "felix.config.properties";
    public static final String CONFIG_PROPERTIES_FILE_VALUE = "config.properties";
    public static final String CONFIG_DIRECTORY = "conf";
    private static final String FULL_JAR_URI_PREFIX = "jar:";
    private static final int FULL_JAR_URI_PREFIX_LENGTH = 4;
    private static final ServiceLoader<FrameworkFactory> frameworkFactoryLoader = ServiceLoader.load(FrameworkFactory.class);
    private static Framework m_fwk = null;

    public static void main(String[] args) throws Exception {
        CommandLineArgs commandLineArgs = CommandLineArgs.parseCommandLineArgs(args);
        Main main = new Main();
        main.start(commandLineArgs);
    }

    public void start(CommandLineArgs commandLineArgs) throws URISyntaxException, MalformedURLException, IOException, MissingPropertyException {
        Path installDirPath = this.getInstallDirPath();
        this.loadSystemProperties(installDirPath);
        Properties defaultConfigProps = this.getDefaultConfigProps();
        Properties installConfigProps = new Properties(defaultConfigProps);
        this.loadConfigProperties(installConfigProps, installDirPath);
        this.overrideInstallConfigProps(installConfigProps, commandLineArgs);
        Path userDirPath = this.getUserDirPath(installConfigProps);
        if (!Files.exists(userDirPath, new LinkOption[0])) {
            Files.createDirectories(userDirPath, new FileAttribute[0]);
        }
        System.out.println("User dir: " + userDirPath);
        Properties userConfigProps = new Properties(installConfigProps);
        this.loadConfigProperties(userConfigProps, userDirPath);
        this.resolveProperties(userConfigProps);
        this.copySystemProperties(userConfigProps);
        this.registerShutdownHook(userConfigProps);
        try {
            FrameworkEvent event;
            FrameworkFactory factory = this.getFrameworkFactory();
            HashMap<String, String> configMap = new HashMap<String, String>(userConfigProps.size());
            for (String propertyName : userConfigProps.stringPropertyNames()) {
                configMap.put(propertyName, userConfigProps.getProperty(propertyName));
            }
            m_fwk = factory.newFramework(configMap);
            m_fwk.init();
            this.initServices();
            AutoProcessor autoProcessor = new AutoProcessor();
            autoProcessor.process(m_fwk, configMap, installDirPath, userDirPath);
            do {
                m_fwk.start();
            } while ((event = m_fwk.waitForStop(0L)).getType() == 128);
            System.exit(0);
        }
        catch (Exception ex) {
            System.err.println("Could not create framework: " + ex);
            ex.printStackTrace();
            System.exit(0);
        }
    }

    private void registerShutdownHook(Properties userConfigProps) {
        String enableHook = userConfigProps.getProperty(SHUTDOWN_HOOK_PROP);
        if (enableHook == null || !enableHook.equalsIgnoreCase("false")) {
            Runtime.getRuntime().addShutdownHook(new Thread("Felix Shutdown Hook"){

                @Override
                public void run() {
                    try {
                        if (m_fwk != null) {
                            m_fwk.stop();
                            m_fwk.waitForStop(0L);
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("Error stopping framework: " + ex);
                    }
                }
            });
        }
    }

    private void resolveProperties(Properties configProps) throws IllegalArgumentException {
        for (String propertyName : configProps.stringPropertyNames()) {
            configProps.setProperty(propertyName, Util.substVars(configProps.getProperty(propertyName), propertyName, null, configProps));
        }
    }

    private void overrideInstallConfigProps(Properties installConfigProps, CommandLineArgs commandLineArgs) {
        if (commandLineArgs.getUserDir() != null) {
            installConfigProps.setProperty(USER_DIR_PROPERTY, commandLineArgs.getUserDir());
        }
    }

    private Path getUserDirPath(Properties installConfigProps) throws MissingPropertyException {
        String userDirName = installConfigProps.getProperty(USER_DIR_PROPERTY);
        if (userDirName == null) {
            throw new MissingPropertyException("Undefined property: platform.userdir");
        }
        return Paths.get(userDirName, new String[0]);
    }

    private FrameworkFactory getFrameworkFactory() throws Exception {
        Iterator<FrameworkFactory> i$ = frameworkFactoryLoader.iterator();
        if (i$.hasNext()) {
            FrameworkFactory frameworkFactory = i$.next();
            return frameworkFactory;
        }
        throw new Exception("Could not find framework factory.");
    }

    protected void loadSystemProperties(Path rootDirPath) throws MalformedURLException, IOException {
        Properties props = new Properties();
        this.loadProperties(props, SYSTEM_PROPERTIES_PROP, rootDirPath, SYSTEM_PROPERTIES_FILE_VALUE);
        for (String propertyName : props.stringPropertyNames()) {
            System.setProperty(propertyName, Util.substVars(props.getProperty(propertyName), propertyName, null, null));
        }
    }

    private void loadProperties(Properties props, String systemPropertyName, Path rootDirPath, String propertiesFileName) throws IOException, MalformedURLException {
        String custom = System.getProperty(systemPropertyName);
        URL propURL = custom != null ? new URL(custom) : rootDirPath.resolve(CONFIG_DIRECTORY).resolve(propertiesFileName).toUri().toURL();
        try (InputStream is = propURL.openConnection().getInputStream();){
            props.load(is);
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            System.err.println("Main: Error loading system properties from " + propURL);
            throw ex;
        }
    }

    private void loadConfigProperties(Properties configProps, Path rootDirPath) throws MalformedURLException, IOException {
        this.loadProperties(configProps, CONFIG_PROPERTIES_PROP, rootDirPath, CONFIG_PROPERTIES_FILE_VALUE);
    }

    private void copySystemProperties(Properties configProps) {
        for (String propertyName : System.getProperties().stringPropertyNames()) {
            if (!propertyName.startsWith("felix.") && !propertyName.startsWith("org.osgi.framework.")) continue;
            configProps.setProperty(propertyName, System.getProperty(propertyName));
        }
    }

    private Path getInstallDirPath() throws URISyntaxException {
        String mainJarURIString;
        Class<Main> type = Main.class;
        String jarResourceURIString = type.getResource("/" + type.getName().replace(".", "/") + ".class").toURI().toString();
        int endOfJarPathIndex = jarResourceURIString.indexOf("!/");
        String string = mainJarURIString = endOfJarPathIndex >= 0 ? jarResourceURIString.substring(0, endOfJarPathIndex) : jarResourceURIString;
        if (mainJarURIString.startsWith(FULL_JAR_URI_PREFIX)) {
            mainJarURIString = mainJarURIString.substring(4);
        }
        Path mainJarPath = Paths.get(URI.create(mainJarURIString));
        return mainJarPath.getParent().getParent();
    }

    protected Properties getDefaultConfigProps() throws IOException {
        Properties props = new Properties();
        try (InputStream is = Main.class.getResourceAsStream(CONFIG_PROPERTIES_FILE_VALUE);){
            props.load(is);
        }
        return props;
    }

    private void initServices() throws IOException {
        m_fwk.getBundleContext().registerService(ApplicationConfigProvider.class, new ApplicationConfigProviderImpl(), null);
    }
}

