/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.startup.main.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drombler.acp.startup.main.ApplicationConfigProvider;

public class ApplicationConfigProviderImpl
implements ApplicationConfigProvider {
    public static final String APPLICATION_PROPERTIES_FILE_PATH = "/applicationConfig.properties";
    private final Map<String, String> applicationConfig;

    public ApplicationConfigProviderImpl() {
        Properties configProperties = new Properties();
        try (InputStream is = ApplicationConfigProviderImpl.class.getResourceAsStream(APPLICATION_PROPERTIES_FILE_PATH);){
            if (is != null) {
                configProperties.load(is);
            }
        }
        catch (IOException ex) {
            System.err.println("ApplicationConfigProviderImpl: Error loading applicationConfig.properties!");
        }
        HashMap<String, String> config = new HashMap<String, String>(configProperties.size());
        for (String propertyName : configProperties.stringPropertyNames()) {
            config.put(propertyName, configProperties.getProperty(propertyName));
        }
        this.applicationConfig = Collections.unmodifiableMap(config);
    }

    @Override
    public Map<String, String> getApplicationConfig() {
        return this.applicationConfig;
    }
}

