/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.startup.main.impl.osgi;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.drombler.acp.startup.main.DromblerACPConfiguration;
import org.drombler.acp.startup.main.ServiceLoaderException;
import org.drombler.acp.startup.main.impl.PropertiesUtils;
import org.drombler.acp.startup.main.impl.osgi.AutoProcessor;
import org.drombler.commons.client.startup.main.BootServiceStarter;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class OSGiStarter
implements BootServiceStarter {
    private static final ServiceLoader<FrameworkFactory> FRAMEWORK_FACTORY_LOADER = ServiceLoader.load(FrameworkFactory.class);
    private final DromblerACPConfiguration configuration;
    private final Map<String, String> configMap;
    private final Framework framework;
    private final boolean active;

    public OSGiStarter(DromblerACPConfiguration configuration, boolean active) {
        this.configuration = configuration;
        this.configMap = PropertiesUtils.toMap(configuration.getUserConfigProps());
        FrameworkFactory factory = this.getFrameworkFactory();
        this.framework = factory.newFramework(this.configMap);
        this.active = active;
    }

    private FrameworkFactory getFrameworkFactory() {
        Iterator<FrameworkFactory> iterator = FRAMEWORK_FACTORY_LOADER.iterator();
        if (iterator.hasNext()) {
            FrameworkFactory frameworkFactory = iterator.next();
            return frameworkFactory;
        }
        throw new ServiceLoaderException("Could not find framework factory.");
    }

    public String getName() {
        return "Felix Starter";
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean init() throws BundleException, IOException {
        this.getFramework().init();
        AutoProcessor autoProcessor = new AutoProcessor();
        autoProcessor.process(this.getFramework(), this.configMap, this.configuration.getInstallDirPath(), this.configuration.getUserDirPath());
        return true;
    }

    public void startAndWait() throws BundleException, InterruptedException {
        FrameworkEvent event;
        do {
            this.logInfo("Starting OSGi Framework...", new Object[0]);
            this.getFramework().start();
        } while ((event = this.getFramework().waitForStop(0L)).getType() == 128);
    }

    public void stop() throws BundleException, InterruptedException {
        if (this.isRunning()) {
            this.getFramework().stop();
            FrameworkEvent stopEvent = this.getFramework().waitForStop(0L);
            System.out.println("OSGi Framework stopped: " + stopEvent.getType());
        }
    }

    public Framework getFramework() {
        return this.framework;
    }

    private void logInfo(String messageFormat, Object ... arguments) {
        System.out.println(MessageFormat.format(messageFormat, arguments));
    }

    public boolean isRunning() {
        return this.getFramework().getState() == 32;
    }

    public boolean isRequired() {
        return true;
    }
}

