/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.startup.main.impl.osgi;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.drombler.acp.startup.main.impl.osgi.BundleAction;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;

class AutoProcessor {
    public static final String AUTO_DEPLOY_DIR_PROPERY = "felix.auto.deploy.dir";
    public static final String AUTO_DEPLOY_DIR_VALUE = "bundle";
    public static final String AUTO_DEPLOY_ACTION_PROPERY = "felix.auto.deploy.action";
    public static final String AUTO_DEPLOY_STARTLEVEL_PROPERY = "felix.auto.deploy.startlevel";
    public static final String AUTO_DEPLOY_INSTALL_VALUE = "install";
    public static final String AUTO_DEPLOY_START_VALUE = "start";
    public static final String AUTO_DEPLOY_UPDATE_VALUE = "update";
    public static final String AUTO_DEPLOY_UNINSTALL_VALUE = "uninstall";
    public static final String AUTO_INSTALL_PROP = "felix.auto.install";
    public static final String AUTO_START_PROP = "felix.auto.start";

    AutoProcessor() {
    }

    public void process(Framework framework, Map<String, String> configMap, Path installDirPath, Path userDirPath) throws IOException {
        if (configMap == null) {
            configMap = new HashMap<String, String>();
        }
        BundleContext frameworkContext = framework.getBundleContext();
        FrameworkStartLevel fsl = (FrameworkStartLevel)framework.adapt(FrameworkStartLevel.class);
        this.processAutoDeploy(configMap, frameworkContext, fsl, installDirPath, userDirPath);
        this.processAutoProperties(configMap, frameworkContext, fsl);
    }

    private void getAutoDeployBundlePaths(Path autoDirPath, final List<Path> jarPaths) throws IOException {
        if (Files.exists(autoDirPath, new LinkOption[0])) {
            Files.walkFileTree(autoDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (file.getFileName().toString().endsWith(".jar")) {
                        jarPaths.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private void processAutoDeploy(Map<String, String> configMap, BundleContext frameworkContext, FrameworkStartLevel fsl, Path installDirPath, Path userDirPath) throws IOException {
        Set<BundleAction> bundleActions = this.getBundleActions(configMap);
        if (!bundleActions.isEmpty()) {
            int startLevel = this.getStartLevel(fsl, configMap);
            Map<String, Bundle> uninstallBundlesMap = this.getInstalledBundlesMap(frameworkContext);
            List<Path> jarPaths = this.getAutoDeployBundlePaths(configMap, installDirPath, userDirPath);
            ArrayList<Bundle> startBundleList = new ArrayList<Bundle>();
            for (Path jarPath : jarPaths) {
                Bundle b = uninstallBundlesMap.remove(jarPath.toUri().toString());
                try {
                    if (b == null && bundleActions.contains((Object)BundleAction.INSTALL)) {
                        b = frameworkContext.installBundle(jarPath.toUri().toString());
                    } else if (b != null && bundleActions.contains((Object)BundleAction.UPDATE)) {
                        b.update();
                    }
                    if (b == null || this.isFragment(b)) continue;
                    startBundleList.add(b);
                    this.setStartLevel(b, startLevel);
                }
                catch (BundleException ex) {
                    System.err.println("Auto-deploy install: " + (Object)((Object)ex) + (ex.getCause() != null ? " - " + ex.getCause() : ""));
                }
            }
            if (bundleActions.contains((Object)BundleAction.UNINSTALL)) {
                this.uninstallBundles(uninstallBundlesMap.values());
            }
            if (bundleActions.contains((Object)BundleAction.START)) {
                this.startBundles(startBundleList);
            }
        }
    }

    private void processAutoProperties(Map<String, String> configMap, BundleContext frameworkContext, FrameworkStartLevel fsl) {
        this.installAutoInstallBundles(configMap, frameworkContext, fsl);
        this.startAutoStartBundles(configMap, frameworkContext);
    }

    private void installAutoInstallBundles(Map<String, String> configMap, BundleContext frameworkContext, FrameworkStartLevel fsl) {
        configMap.keySet().stream().map(key -> key.toLowerCase()).filter(key -> key.startsWith(AUTO_INSTALL_PROP) || key.startsWith(AUTO_START_PROP)).forEach(key -> {
            int startLevel = this.getAutoStartLevel(fsl, (String)key);
            StringTokenizer st = AutoProcessor.createStringTokenizer((String)configMap.get(key));
            String location = this.nextLocation(st);
            while (location != null) {
                this.installBundle(location, frameworkContext, startLevel);
                location = this.nextLocation(st);
            }
        });
    }

    private void startAutoStartBundles(Map<String, String> configMap, BundleContext frameworkContext) {
        configMap.keySet().stream().map(key -> key.toLowerCase()).filter(key -> key.startsWith(AUTO_START_PROP)).map(key -> AutoProcessor.createStringTokenizer((String)configMap.get(key))).forEach(st -> {
            String location = this.nextLocation((StringTokenizer)st);
            while (location != null) {
                this.startBundle(frameworkContext, location);
                location = this.nextLocation((StringTokenizer)st);
            }
        });
    }

    private static StringTokenizer createStringTokenizer(String value) {
        return new StringTokenizer(value, "\" ", true);
    }

    private int getAutoStartLevel(FrameworkStartLevel fsl, String key) {
        int startLevel = fsl.getInitialBundleStartLevel();
        if (!key.equals(AUTO_INSTALL_PROP) && !key.equals(AUTO_START_PROP)) {
            try {
                startLevel = Integer.parseInt(key.substring(key.lastIndexOf(46) + 1));
            }
            catch (NumberFormatException ex) {
                System.err.println("Invalid property: " + key);
            }
        }
        return startLevel;
    }

    private void installBundle(String location, BundleContext frameworkContext, int startLevel) {
        block2: {
            try {
                Bundle b = frameworkContext.installBundle(location, null);
                this.setStartLevel(b, startLevel);
            }
            catch (RuntimeException | BundleException ex) {
                System.err.println("Auto-properties install: " + location + " (" + ex + (ex.getCause() != null ? " - " + ex.getCause() : "") + ")");
                if (ex.getCause() == null) break block2;
                ex.printStackTrace();
            }
        }
    }

    private void uninstallBundles(Collection<Bundle> bundles) {
        bundles.stream().filter(bundle -> bundle.getBundleId() != 0L).forEach(bundle -> {
            try {
                bundle.uninstall();
            }
            catch (BundleException ex) {
                System.err.println("Auto-deploy uninstall: " + (Object)((Object)ex) + (ex.getCause() != null ? " - " + ex.getCause() : ""));
            }
        });
    }

    private void startBundles(List<Bundle> startBundleList) {
        startBundleList.forEach(bundle -> {
            try {
                bundle.start();
            }
            catch (Exception ex) {
                System.err.println("Auto-deploy start: " + ex + (ex.getCause() != null ? " - " + ex.getCause() : ""));
            }
        });
    }

    private void setStartLevel(Bundle bundle, int startLevel) {
        BundleStartLevel bsl = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        bsl.setStartLevel(startLevel);
    }

    private void startBundle(BundleContext frameworkContext, String location) {
        try {
            Bundle b = frameworkContext.installBundle(location, null);
            if (b != null) {
                b.start();
            }
        }
        catch (Exception ex) {
            System.err.println("Auto-properties start: " + location + " (" + ex + (ex.getCause() != null ? " - " + ex.getCause() : "") + ")");
        }
    }

    private int getStartLevel(FrameworkStartLevel fsl, Map<String, String> configMap) {
        int startLevel = fsl.getInitialBundleStartLevel();
        if (configMap.get(AUTO_DEPLOY_STARTLEVEL_PROPERY) != null) {
            try {
                startLevel = Integer.parseInt(configMap.get(AUTO_DEPLOY_STARTLEVEL_PROPERY).toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return startLevel;
    }

    private Set<BundleAction> getBundleActions(Map<String, String> configMap) {
        String action = configMap.get(AUTO_DEPLOY_ACTION_PROPERY);
        if (action == null) {
            action = "";
        }
        return this.getBundleActions(action);
    }

    private Set<BundleAction> getBundleActions(String action) {
        return this.getBundleActions(new StringTokenizer(action, ","));
    }

    private Set<BundleAction> getBundleActions(StringTokenizer st) {
        EnumSet<BundleAction> bundleActions = EnumSet.noneOf(BundleAction.class);
        while (st.hasMoreTokens()) {
            BundleAction bundleAction = BundleAction.getBundleAction(st.nextToken().trim().toLowerCase());
            if (bundleAction == null) continue;
            bundleActions.add(bundleAction);
        }
        return bundleActions;
    }

    private List<Path> getAutoDeployBundlePaths(Map<String, String> configMap, Path installDirPath, Path userDirPath) throws IOException {
        String autoDir = this.getAutoDeployDir(configMap);
        ArrayList<Path> jarPaths = new ArrayList<Path>();
        this.getAutoDeployBundlePaths(installDirPath.resolve(autoDir), jarPaths);
        this.getAutoDeployBundlePaths(userDirPath.resolve(autoDir), jarPaths);
        Collections.sort(jarPaths);
        return jarPaths;
    }

    private String getAutoDeployDir(Map<String, String> configMap) {
        String autoDir = configMap.get(AUTO_DEPLOY_DIR_PROPERY);
        if (autoDir == null) {
            autoDir = AUTO_DEPLOY_DIR_VALUE;
        }
        return autoDir;
    }

    private Map<String, Bundle> getInstalledBundlesMap(BundleContext frameworkContext) {
        return Arrays.stream(frameworkContext.getBundles()).collect(Collectors.toMap(bundle -> bundle.getLocation(), bundle -> bundle));
    }

    private String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuffer tokBuf = new StringBuffer(10);
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            block8: while (st.hasMoreTokens() && !exit) {
                String tok;
                switch (tok = st.nextToken(tokenList)) {
                    case "\"": {
                        boolean bl = inQuote = !inQuote;
                        if (inQuote) {
                            tokenList = "\"";
                            continue block8;
                        }
                        tokenList = "\" ";
                        continue block8;
                    }
                    case " ": {
                        if (!tokStarted) continue block8;
                        retVal = tokBuf.toString();
                        tokStarted = false;
                        tokBuf = new StringBuffer(10);
                        exit = true;
                        continue block8;
                    }
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }

    private boolean isFragment(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") != null;
    }
}

