/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.startup.main;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.felix.framework.util.Util;
import org.drombler.commons.client.startup.main.DromblerClientConfiguration;
import org.drombler.commons.client.startup.main.MissingPropertyException;
import org.drombler.commons.client.startup.main.cli.CommandLineArgs;

public class DromblerACPConfiguration
extends DromblerClientConfiguration {
    public DromblerACPConfiguration(CommandLineArgs commandLineArgs) throws URISyntaxException, IOException, MissingPropertyException {
        super(commandLineArgs);
    }

    protected Path determineInstallDirPath(Path mainJarPath) {
        return mainJarPath.getParent().getParent().getParent();
    }

    protected Properties loadDefaultConfigProps() throws IOException {
        Properties properties = new Properties(super.loadDefaultConfigProps());
        try (InputStream is = DromblerACPConfiguration.class.getResourceAsStream("config.properties");){
            properties.load(is);
        }
        return properties;
    }

    protected void resolveProperties(Properties configProps) throws IllegalArgumentException {
        super.resolveProperties(configProps);
        for (String propertyName : configProps.stringPropertyNames()) {
            configProps.setProperty(propertyName, Util.substVars((String)configProps.getProperty(propertyName), (String)propertyName, null, (Properties)configProps));
        }
    }

    protected void copySystemProperties(Properties configProps) {
        super.copySystemProperties(configProps);
        System.getProperties().stringPropertyNames().stream().filter(propertyName -> propertyName.startsWith("felix.") || propertyName.startsWith("org.osgi.framework.")).forEach(propertyName -> configProps.setProperty((String)propertyName, System.getProperty(propertyName)));
    }
}

