/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.status.spi;

import java.util.EnumMap;
import java.util.Map;
import org.drombler.acp.core.commons.util.BundleUtils;
import org.drombler.acp.core.status.jaxb.HorizontalAlignmentType;
import org.drombler.acp.core.status.jaxb.StatusBarElementType;
import org.drombler.commons.client.geometry.HorizontalAlignment;
import org.osgi.framework.Bundle;

public class StatusBarElementDescriptor<T> {
    private static final Map<HorizontalAlignmentType, HorizontalAlignment> HORIZONTAL_ALIGNMENT_MAP = new EnumMap<HorizontalAlignmentType, HorizontalAlignment>(HorizontalAlignmentType.class);
    private final Class<T> statusBarElementClass;
    private final HorizontalAlignment horizontalAlignment;
    private final int position;

    public StatusBarElementDescriptor(Class<T> statusBarElementClass, HorizontalAlignment horizontalAlignment, int position) {
        this.statusBarElementClass = statusBarElementClass;
        this.horizontalAlignment = horizontalAlignment;
        this.position = position;
    }

    public Class<T> getStatusBarElementClass() {
        return this.statusBarElementClass;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getPosition() {
        return this.position;
    }

    public static StatusBarElementDescriptor<?> createStatusBarElementDescriptor(StatusBarElementType statusBarElement, Bundle bundle) throws ClassNotFoundException {
        Class statusBarElementClass = BundleUtils.loadClass((Bundle)bundle, (String)statusBarElement.getStatusBarElementClass());
        return StatusBarElementDescriptor.createStatusBarElementDescriptor(statusBarElement, statusBarElementClass);
    }

    private static <T> StatusBarElementDescriptor<T> createStatusBarElementDescriptor(StatusBarElementType statusBarElement, Class<T> statusBarElementClass) {
        return new StatusBarElementDescriptor<T>(statusBarElementClass, HORIZONTAL_ALIGNMENT_MAP.get(statusBarElement.getHorizontalAlignment()), statusBarElement.getPosition());
    }

    static {
        HORIZONTAL_ALIGNMENT_MAP.put(HorizontalAlignmentType.LEFT, HorizontalAlignment.LEFT);
        HORIZONTAL_ALIGNMENT_MAP.put(HorizontalAlignmentType.CENTER, HorizontalAlignment.CENTER);
        HORIZONTAL_ALIGNMENT_MAP.put(HorizontalAlignmentType.RIGHT, HorizontalAlignment.RIGHT);
        HORIZONTAL_ALIGNMENT_MAP.put(HorizontalAlignmentType.LEADING, HorizontalAlignment.LEADING);
        HORIZONTAL_ALIGNMENT_MAP.put(HorizontalAlignmentType.TRAILING, HorizontalAlignment.TRAILING);
        for (HorizontalAlignmentType dockingAreaKind : HorizontalAlignmentType.values()) {
            if (HORIZONTAL_ALIGNMENT_MAP.containsKey(dockingAreaKind)) continue;
            throw new IllegalStateException("No mapping for: " + dockingAreaKind);
        }
    }
}

