/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.standard.action.data.file.impl;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import org.drombler.acp.core.commons.util.SimpleServiceTrackerCustomizer;
import org.drombler.acp.core.commons.util.concurrent.ApplicationThreadConsumer;
import org.drombler.acp.core.commons.util.concurrent.ApplicationThreadExecutorProvider;
import org.drombler.acp.core.context.ContextManagerProvider;
import org.drombler.acp.core.data.spi.DataHandlerRegistryProvider;
import org.drombler.acp.core.data.spi.DocumentHandlerDescriptorRegistryProvider;
import org.drombler.acp.core.data.spi.FileExtensionDescriptorRegistryProvider;
import org.drombler.commons.action.AbstractActionListener;
import org.drombler.commons.client.dialog.FileChooserProvider;
import org.drombler.commons.context.ContextInjector;
import org.drombler.commons.context.ContextManager;
import org.drombler.commons.data.DataHandlerRegistry;
import org.drombler.commons.data.file.DocumentHandlerDescriptorRegistry;
import org.drombler.commons.data.file.FileExtensionDescriptorRegistry;
import org.drombler.commons.data.file.FileUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class OpenFilesAction
extends AbstractActionListener<Object>
implements AutoCloseable {
    private final ServiceTracker<ApplicationThreadExecutorProvider, ApplicationThreadExecutorProvider> applicationThreadExecutorProviderServiceTracker = SimpleServiceTrackerCustomizer.createServiceTracker((BundleContext)FrameworkUtil.getBundle(OpenFilesAction.class).getBundleContext(), ApplicationThreadExecutorProvider.class, this::setApplicationThreadExecutorProvider);
    private ServiceTracker<FileChooserProvider, FileChooserProvider> fileChooserProviderServiceTracker;
    private ServiceTracker<FileExtensionDescriptorRegistryProvider, FileExtensionDescriptorRegistryProvider> fileExtensionDescriptorRegistryProviderServiceTracker;
    private ServiceTracker<DocumentHandlerDescriptorRegistryProvider, DocumentHandlerDescriptorRegistryProvider> documentHandlerDescriptorRegistryServiceTracker;
    private ServiceTracker<DataHandlerRegistryProvider, DataHandlerRegistryProvider> dataHandlerRegistryServiceTracker;
    private ServiceTracker<ContextManagerProvider, ContextManagerProvider> contextManagerServiceTracker;
    private FileChooserProvider fileChooserProvider;
    private FileExtensionDescriptorRegistryProvider fileExtensionDescriptorRegistryProvider;
    private DocumentHandlerDescriptorRegistryProvider documentHandlerDescriptorRegistryProvider;
    private DataHandlerRegistryProvider dataHandlerRegistryProvider;
    private ApplicationThreadExecutorProvider applicationThreadExecutorProvider;
    private ContextManagerProvider contextManagerProvider;
    private ContextInjector contextInjector;

    public OpenFilesAction() {
        this.applicationThreadExecutorProviderServiceTracker.open(true);
        this.setEnabled(this.isInitialized());
    }

    public void onAction(Object event) {
        List filePaths = this.fileChooserProvider.showOpenMultipleDialog();
        if (filePaths != null) {
            filePaths.forEach(this::openFile);
        }
    }

    private boolean isInitialized() {
        return this.fileChooserProvider != null && this.fileExtensionDescriptorRegistryProvider != null && this.documentHandlerDescriptorRegistryProvider != null && this.dataHandlerRegistryProvider != null;
    }

    private void openFile(Path fileToOpen) {
        FileUtils.openFile((Path)fileToOpen, (DataHandlerRegistry)this.dataHandlerRegistryProvider.getDataHandlerRegistry(), (FileExtensionDescriptorRegistry)this.fileExtensionDescriptorRegistryProvider.getFileExtensionDescriptorRegistry(), (DocumentHandlerDescriptorRegistry)this.documentHandlerDescriptorRegistryProvider.getDocumentHandlerDescriptorRegistry(), (ContextManager)this.contextManagerProvider.getContextManager(), (ContextInjector)this.contextInjector);
    }

    public ApplicationThreadExecutorProvider getApplicationThreadExecutorProvider() {
        return this.applicationThreadExecutorProvider;
    }

    public void setApplicationThreadExecutorProvider(ApplicationThreadExecutorProvider applicationThreadExecutorProvider) {
        this.applicationThreadExecutorProvider = applicationThreadExecutorProvider;
        if (this.applicationThreadExecutorProvider != null) {
            this.fileChooserProviderServiceTracker = SimpleServiceTrackerCustomizer.createServiceTracker(FileChooserProvider.class, (Consumer)new ApplicationThreadConsumer(this.applicationThreadExecutorProvider, this::setFileChooserProvider));
            this.fileExtensionDescriptorRegistryProviderServiceTracker = SimpleServiceTrackerCustomizer.createServiceTracker(FileExtensionDescriptorRegistryProvider.class, (Consumer)new ApplicationThreadConsumer(this.applicationThreadExecutorProvider, this::setFileExtensionDescriptorRegistryProvider));
            this.documentHandlerDescriptorRegistryServiceTracker = SimpleServiceTrackerCustomizer.createServiceTracker(DocumentHandlerDescriptorRegistryProvider.class, (Consumer)new ApplicationThreadConsumer(this.applicationThreadExecutorProvider, this::setDocumentHandlerDescriptorRegistryProvider));
            this.dataHandlerRegistryServiceTracker = SimpleServiceTrackerCustomizer.createServiceTracker(DataHandlerRegistryProvider.class, (Consumer)new ApplicationThreadConsumer(this.applicationThreadExecutorProvider, this::setDataHandlerRegistryProvider));
            this.contextManagerServiceTracker = SimpleServiceTrackerCustomizer.createServiceTracker(ContextManagerProvider.class, (Consumer)new ApplicationThreadConsumer(this.applicationThreadExecutorProvider, this::setContextManagerProvider));
            this.fileChooserProviderServiceTracker.open(true);
            this.fileExtensionDescriptorRegistryProviderServiceTracker.open(true);
            this.documentHandlerDescriptorRegistryServiceTracker.open(true);
            this.dataHandlerRegistryServiceTracker.open(true);
            this.contextManagerServiceTracker.open(true);
        } else {
            this.fileChooserProviderServiceTracker.close();
            this.fileChooserProviderServiceTracker = null;
            this.fileExtensionDescriptorRegistryProviderServiceTracker.close();
            this.fileExtensionDescriptorRegistryProviderServiceTracker = null;
            this.documentHandlerDescriptorRegistryServiceTracker.close();
            this.documentHandlerDescriptorRegistryServiceTracker = null;
            this.dataHandlerRegistryServiceTracker.close();
            this.dataHandlerRegistryServiceTracker = null;
            this.contextManagerServiceTracker.close();
            this.contextManagerServiceTracker = null;
        }
    }

    public FileChooserProvider getFileChooserProvider() {
        return this.fileChooserProvider;
    }

    public void setFileChooserProvider(FileChooserProvider fileChooserProvider) {
        this.fileChooserProvider = fileChooserProvider;
        this.setEnabled(this.isInitialized());
    }

    public FileExtensionDescriptorRegistryProvider getFileExtensionDescriptorRegistryProvider() {
        return this.fileExtensionDescriptorRegistryProvider;
    }

    public void setFileExtensionDescriptorRegistryProvider(FileExtensionDescriptorRegistryProvider fileExtensionDescriptorRegistryProvider) {
        this.fileExtensionDescriptorRegistryProvider = fileExtensionDescriptorRegistryProvider;
        this.setEnabled(this.isInitialized());
    }

    public DocumentHandlerDescriptorRegistryProvider getDocumentHandlerDescriptorRegistryProvider() {
        return this.documentHandlerDescriptorRegistryProvider;
    }

    public void setDocumentHandlerDescriptorRegistryProvider(DocumentHandlerDescriptorRegistryProvider documentHandlerDescriptorRegistryProvider) {
        this.documentHandlerDescriptorRegistryProvider = documentHandlerDescriptorRegistryProvider;
        this.setEnabled(this.isInitialized());
    }

    public DataHandlerRegistryProvider getDataHandlerRegistryProvider() {
        return this.dataHandlerRegistryProvider;
    }

    public void setDataHandlerRegistryProvider(DataHandlerRegistryProvider dataHandlerRegistryProvider) {
        this.dataHandlerRegistryProvider = dataHandlerRegistryProvider;
        this.setEnabled(this.isInitialized());
    }

    public void setContextManagerProvider(ContextManagerProvider contextManagerProvider) {
        this.contextManagerProvider = contextManagerProvider;
        this.contextInjector = contextManagerProvider != null ? new ContextInjector(contextManagerProvider.getContextManager()) : null;
        this.setEnabled(this.isInitialized());
    }

    @Override
    public void close() {
        this.applicationThreadExecutorProviderServiceTracker.close();
    }
}

